/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.service;

import java.util.ArrayList;
import java.util.UUID;
import net.blugrid.core.model.Event;
import net.blugrid.core.model.MessageInstance;
import net.blugrid.core.model.Party;
import net.blugrid.core.model.Token;
import net.blugrid.service.EventService;
import net.blugrid.service.WebMailerConnector;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class EventServiceImpl
implements EventService {
    private static final Logger logger = Logger.getLogger(EventServiceImpl.class);
    private static final String BASE_URL = "http://localhost:8080/v2.0/";
    @Autowired
    private WebMailerConnector WebMailerconnector;

    @Override
    public void sendSignUpMessage(Token token, UUID eventuuid, Party party) {
        Event event = this.getByUUID(token, eventuuid);
        if (event.getSignupemail() != null) {
            MessageInstance messageisntance = new MessageInstance();
            messageisntance.setRecipient(party);
            messageisntance.setMessageuuid(event.getSignupemail().getMessageuuid());
            messageisntance.setEventuuid(eventuuid);
            ArrayList<MessageInstance> messageinstances = new ArrayList<MessageInstance>();
            messageinstances.add(messageisntance);
            this.WebMailerconnector.sendEmail(token, event.getSignupemail().getMessageuuid());
        }
    }

    @Override
    public Event getByUUID(Token token, UUID uuid) {
        Event event = new Event();
        RestTemplate template = new RestTemplate();
        String url = "http://localhost:8080/v2.0/event/" + uuid;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", token.getJwttoken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            logger.info((Object)("get event by uuid  " + url));
            ResponseEntity restResponse = template.exchange(url, HttpMethod.GET, requestEntity, Event.class, new Object[0]);
            logger.info((Object)("web-mailer response: " + restResponse.getStatusCode()));
            event = (Event)restResponse.getBody();
        }
        catch (HttpClientErrorException e) {
            logger.error((Object)(e.getStatusCode().toString() + ": " + e.getResponseBodyAsString()));
        }
        catch (RestClientException e) {
            logger.error((Object)e.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
        return event;
    }
}

