/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileUtilsImpl
implements FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class);

    @Override
    public File convertMultipartFileToFile(Token token, MultipartFile file) {
        File response = new File("/data/temp/" + token.getSessionuuid().toString() + "_" + file.getOriginalFilename());
        if (!file.isEmpty()) {
            try {
                byte[] bytes = file.getBytes();
                BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(response));
                stream.write(bytes);
                stream.close();
                logger.info((Object)("Multi-part file saved: " + response.getAbsolutePath()));
            }
            catch (IOException ex) {
                logger.error((Object)ex);
            }
        }
        return response;
    }

    @Override
    public File convertByteArrayToFile(Token token, byte[] ba, String tempfile) {
        File response = new File("/data/temp/" + token.getSessionuuid().toString() + "_" + tempfile);
        try {
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(response));
            stream.write(ba);
            stream.close();
            logger.info((Object)("Multi-part file saved: " + response.getAbsolutePath()));
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File convertStringToFile(Token token, String doc, String filename) {
        File file = new File("/data/temp/" + token.getSessionuuid().toString() + "_" + filename);
        if (doc != null) {
            BufferedWriter bufferedWriter = null;
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileWriter writer = new FileWriter(file);
                bufferedWriter = new BufferedWriter(writer);
                bufferedWriter.write(doc);
                logger.info((Object)("String to file saved: " + file.getAbsolutePath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
        return file;
    }
}

