/*
 * Decompiled with CFR 0.152.
 */
package net.bican.wordpress.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.bican.wordpress.exceptions.InvalidPostFormatException;
import net.bican.wordpress.util.JSONConvertable;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redstone.xmlrpc.XmlRpcArray;
import redstone.xmlrpc.XmlRpcStruct;

public class FileParser {
    private static final Logger logger = LoggerFactory.getLogger(FileParser.class);

    static String getClassName(String key) {
        String className = key;
        while (className.contains("_")) {
            int pos = className.indexOf("_");
            Character ch = Character.valueOf(className.charAt(pos + 1));
            char chNew = Character.toUpperCase(ch.charValue());
            className = className.replaceFirst("_" + ch, chNew + "");
        }
        className = className.replaceFirst("s$", "");
        Character ch = Character.valueOf(className.charAt(0));
        char chNew = Character.toUpperCase(ch.charValue());
        className = className.replaceFirst("^" + ch, chNew + "");
        return "net.bican.wordpress." + className;
    }

    public static XmlRpcStruct parseFile(BufferedReader input) throws IOException, InvalidPostFormatException {
        String line;
        XmlRpcStruct p = new XmlRpcStruct();
        String prevKey = null;
        String prevValue = null;
        Pattern keyPattern = Pattern.compile("^[\\d\\w_]+:", 66);
        while ((line = input.readLine()) != null) {
            if ("".equals(line) || line.startsWith("#")) continue;
            Matcher m = keyPattern.matcher(line);
            if (m.find()) {
                if (prevKey != null) {
                    FileParser.putVal(p, prevKey, prevValue);
                }
                String[] vals = line.split(":", 2);
                prevKey = vals[0];
                prevValue = vals[1];
                continue;
            }
            if (prevValue != null) {
                prevValue = prevValue + line;
                continue;
            }
            throw new InvalidPostFormatException();
        }
        if (prevKey != null) {
            FileParser.putVal(p, prevKey, prevValue);
        }
        return p;
    }

    public static void putVal(XmlRpcStruct s, String key, String v) {
        block9: {
            String value = v.trim();
            if (value.startsWith("[")) {
                try {
                    JSONArray jArr = new JSONArray(value);
                    if (jArr.length() <= 0) break block9;
                    Class<?> cType = jArr.get(0).getClass();
                    XmlRpcArray vals = new XmlRpcArray();
                    if (cType == String.class) {
                        for (int i = 0; i < jArr.length(); ++i) {
                            vals.add((Object)jArr.getString(i));
                        }
                    } else {
                        String className = FileParser.getClassName(key);
                        Class<?> cl = Class.forName(className);
                        for (int i = 0; i < jArr.length(); ++i) {
                            JSONConvertable o = (JSONConvertable)cl.newInstance();
                            o.fromJSONObject(jArr.getJSONObject(i));
                            vals.add((Object)o);
                        }
                    }
                    s.put((Object)key, (Object)vals);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | JSONException e) {
                    logger.error("cannot put key {} value {}: {}", new Object[]{key, v, e.getLocalizedMessage()});
                }
            } else if (!"null".equalsIgnoreCase(value)) {
                s.put((Object)key, (Object)value);
            }
        }
    }
}

