/*
 * Decompiled with CFR 0.152.
 */
package net.bican.wordpress;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import net.bican.wordpress.Author;
import net.bican.wordpress.Comment;
import net.bican.wordpress.CommentCount;
import net.bican.wordpress.CommentStatusList;
import net.bican.wordpress.FilterMediaItem;
import net.bican.wordpress.FilterPost;
import net.bican.wordpress.FilterUser;
import net.bican.wordpress.MediaItem;
import net.bican.wordpress.MediaItemUploadResult;
import net.bican.wordpress.Option;
import net.bican.wordpress.PingbackBridge;
import net.bican.wordpress.PingbackExtensionsBridge;
import net.bican.wordpress.Post;
import net.bican.wordpress.PostType;
import net.bican.wordpress.Taxonomy;
import net.bican.wordpress.Term;
import net.bican.wordpress.TermFilter;
import net.bican.wordpress.User;
import net.bican.wordpress.UserBlog;
import net.bican.wordpress.WordpressBridge;
import net.bican.wordpress.XmlRpcMapped;
import net.bican.wordpress.exceptions.FileUploadException;
import net.bican.wordpress.exceptions.InsufficientRightsException;
import net.bican.wordpress.exceptions.InvalidArgumentsException;
import net.bican.wordpress.exceptions.ObjectNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redstone.xmlrpc.XmlRpcArray;
import redstone.xmlrpc.XmlRpcFault;
import redstone.xmlrpc.XmlRpcProxy;
import redstone.xmlrpc.XmlRpcStruct;

public class Wordpress {
    private static final Integer BLOGID = 0;
    private static final Logger logger = LoggerFactory.getLogger(Wordpress.class);
    private String password = null;
    private PingbackBridge pingback = null;
    private PingbackExtensionsBridge pingbackExt = null;
    private String username = null;
    private WordpressBridge wp = null;
    private String xmlRpcUrl = null;

    private static <T extends XmlRpcMapped> List<T> fillFromXmlRpcArray(XmlRpcArray r, Class<T> cl, T item) {
        ArrayList<XmlRpcMapped> result = null;
        try {
            result = new ArrayList<XmlRpcMapped>();
            for (Object o : r) {
                XmlRpcMapped n = (XmlRpcMapped)cl.newInstance();
                if (o instanceof String) {
                    result.add((XmlRpcMapped)o);
                } else {
                    n.fromXmlRpcStruct((XmlRpcStruct)o);
                }
                result.add(n);
            }
        }
        catch (InstantiationException e) {
            logger.error("cannot instantiate {}: {}", (Object)cl.getCanonicalName(), (Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error("cannot access constructor of {}: {}", (Object)cl.getCanonicalName(), (Object)e);
        }
        return result;
    }

    private static List<Option> structToOptions(XmlRpcStruct r) {
        ArrayList<Option> result = new ArrayList<Option>();
        for (Object o : r.keySet()) {
            String name = (String)o;
            Option option = new Option();
            option.setName(name);
            option.fromXmlRpcStruct(r.getStruct(o));
            result.add(option);
        }
        return result;
    }

    private Wordpress() {
    }

    public Wordpress(String username, String password, String xmlRpcUrl) throws MalformedURLException {
        this.username = username;
        this.password = password;
        this.xmlRpcUrl = xmlRpcUrl;
        this.initMetaWebLog();
    }

    public boolean deleteComment(Integer commentID) throws InsufficientRightsException, ObjectNotFoundException, XmlRpcFault {
        try {
            return this.wp.deleteComment(BLOGID, this.username, this.password, commentID);
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 403: {
                    throw new InsufficientRightsException(e);
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public boolean deletePost(Integer postId) throws InsufficientRightsException, ObjectNotFoundException, XmlRpcFault {
        try {
            return this.wp.deletePost(BLOGID, this.username, this.password, postId);
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public boolean deleteTerm(String taxonomy, Integer termId) throws InsufficientRightsException, XmlRpcFault {
        try {
            Boolean r = this.wp.deleteTerm(BLOGID, this.username, this.password, taxonomy, termId);
            return r;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 404: {
                    return false;
                }
            }
            throw e;
        }
    }

    public boolean editComment(Comment comment) throws InvalidArgumentsException, InsufficientRightsException, ObjectNotFoundException, XmlRpcFault {
        try {
            Boolean r = this.wp.editComment(BLOGID, this.username, this.password, comment.getComment_id(), comment);
            return r;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InvalidArgumentsException(e);
                }
                case 403: {
                    throw new InsufficientRightsException(e);
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public boolean editPost(Integer postId, Post post) throws InsufficientRightsException, InvalidArgumentsException, ObjectNotFoundException, XmlRpcFault {
        try {
            List<Term> oldTerms = post.getTerms();
            XmlRpcStruct postX = post.toXmlRpcStruct();
            if (oldTerms != null) {
                XmlRpcStruct newTerms = new XmlRpcStruct();
                for (Term term : post.getTerms()) {
                    XmlRpcArray ts = (XmlRpcArray)newTerms.get((Object)term.getTaxonomy());
                    if (ts == null) {
                        XmlRpcArray tXs = new XmlRpcArray();
                        tXs.add((Object)term.getTerm_id());
                        newTerms.put((Object)term.getTaxonomy(), (Object)tXs);
                        continue;
                    }
                    ts.add((Object)term.getTerm_id());
                }
                postX.put((Object)"terms", (Object)newTerms);
            }
            Boolean r = this.wp.editPost(BLOGID, this.username, this.password, postId, postX);
            return r;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 403: {
                    throw new InvalidArgumentsException(e);
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public boolean editProfile(User user) throws InsufficientRightsException, XmlRpcFault {
        try {
            XmlRpcStruct content = new XmlRpcStruct();
            if (user.getFirst_name() != null) {
                content.put((Object)"first_name", (Object)user.getFirst_name());
            }
            if (user.getLast_name() != null) {
                content.put((Object)"last_name", (Object)user.getLast_name());
            }
            if (user.getUrl() != null) {
                content.put((Object)"url", (Object)user.getUrl());
            }
            if (user.getDisplay_name() != null) {
                content.put((Object)"display_name", (Object)user.getDisplay_name());
            }
            if (user.getNickname() != null) {
                content.put((Object)"nickname", (Object)user.getNickname());
            }
            if (user.getNicename() != null) {
                content.put((Object)"nicename", (Object)user.getNicename());
            }
            Boolean r = this.wp.editProfile(BLOGID, this.username, this.password, content);
            return r;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
            }
            throw e;
        }
    }

    public boolean editTerm(Integer termId, Term content) throws InsufficientRightsException, InvalidArgumentsException, ObjectNotFoundException, XmlRpcFault {
        try {
            XmlRpcStruct datar = new XmlRpcStruct();
            datar.put((Object)"taxonomy", (Object)content.getTaxonomy());
            if (content.getName() != null) {
                datar.put((Object)"name", (Object)content.getName());
            }
            if (content.getSlug() != null) {
                datar.put((Object)"slug", (Object)content.getSlug());
            }
            if (content.getDescription() != null) {
                datar.put((Object)"description", (Object)content.getDescription());
            }
            if (content.getParent() != null) {
                datar.put((Object)"parent", (Object)content.getParent());
            }
            Boolean r = this.wp.editTerm(BLOGID, this.username, this.password, termId, datar);
            return r;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 403: {
                    throw new InvalidArgumentsException(content.getTaxonomy());
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public List<Author> getAuthors() throws InsufficientRightsException, XmlRpcFault {
        try {
            XmlRpcArray r = this.wp.getAuthors(BLOGID, this.username, this.password);
            return Wordpress.fillFromXmlRpcArray(r, Author.class, new Author());
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
            }
            throw e;
        }
    }

    public Comment getComment(Integer comment_id) throws XmlRpcFault, InsufficientRightsException, ObjectNotFoundException {
        try {
            XmlRpcStruct struct = this.wp.getComment(BLOGID, this.username, this.password, comment_id);
            Comment comment = new Comment();
            comment.fromXmlRpcStruct(struct);
            return comment;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 403: {
                    throw new InsufficientRightsException(e);
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public List<Comment> getComments(String status, Integer post_id, Integer number, Integer offset) throws InsufficientRightsException, XmlRpcFault {
        try {
            XmlRpcStruct filter = new XmlRpcStruct();
            if (status != null) {
                filter.put((Object)"status", (Object)status);
            }
            if (post_id != null) {
                filter.put((Object)"post_id", (Object)post_id);
            }
            if (number != null) {
                filter.put((Object)"number", (Object)number);
            }
            if (offset != null) {
                filter.put((Object)"offset", (Object)offset);
            }
            XmlRpcArray r = this.wp.getComments(BLOGID, this.username, this.password, filter);
            return Wordpress.fillFromXmlRpcArray(r, Comment.class, new Comment());
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
            }
            throw e;
        }
    }

    public CommentCount getCommentsCount(Integer postId) throws XmlRpcFault, InsufficientRightsException {
        try {
            XmlRpcStruct struct = postId != -1 ? this.wp.getCommentCount(BLOGID, this.username, this.password, postId) : this.wp.getCommentCount(BLOGID, this.username, this.password);
            CommentCount cc = new CommentCount();
            cc.fromXmlRpcStruct(struct);
            return cc;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 403: {
                    throw new InsufficientRightsException(e);
                }
            }
            throw e;
        }
    }

    public CommentStatusList getCommentStatusList() throws XmlRpcFault {
        XmlRpcStruct csl = this.wp.getCommentStatusList(BLOGID, this.username, this.password);
        CommentStatusList result = new CommentStatusList();
        result.fromXmlRpcStruct(csl);
        return result;
    }

    public MediaItem getMediaItem(Integer attachmentId) throws InsufficientRightsException, ObjectNotFoundException, XmlRpcFault {
        try {
            XmlRpcStruct r = this.wp.getMediaItem(BLOGID, this.username, this.password, attachmentId);
            MediaItem result = new MediaItem();
            result.fromXmlRpcStruct(r);
            return result;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 403: {
                    throw new InsufficientRightsException(e);
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public List<MediaItem> getMediaLibrary() throws InsufficientRightsException, XmlRpcFault {
        return this.getMediaLibrary(null);
    }

    public List<MediaItem> getMediaLibrary(FilterMediaItem filter) throws InsufficientRightsException, XmlRpcFault {
        try {
            XmlRpcArray r;
            if (filter != null) {
                XmlRpcStruct filterXml = new XmlRpcStruct();
                if (filter.getMime_type() != null) {
                    filterXml.put((Object)"mime_type", (Object)filter.getMime_type());
                }
                if (filter.getNumber() != null) {
                    filterXml.put((Object)"number", (Object)filter.getNumber());
                }
                if (filter.getOffset() != null) {
                    filterXml.put((Object)"offset", (Object)filter.getOffset());
                }
                if (filter.getParent_id() != null) {
                    filterXml.put((Object)"parent_id", (Object)filter.getParent_id());
                }
                r = this.wp.getMediaLibrary(BLOGID, this.username, this.password, filterXml);
            } else {
                r = this.wp.getMediaLibrary(BLOGID, this.username, this.password);
            }
            return Wordpress.fillFromXmlRpcArray(r, MediaItem.class, new MediaItem());
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
            }
            throw e;
        }
    }

    public Option getOption(String optionName) throws XmlRpcFault {
        List<Option> result = this.getOptions(optionName, null);
        return result == null || result.size() == 0 ? null : result.get(0);
    }

    public List<Option> getOptions() throws XmlRpcFault {
        return this.getOptions(null, null);
    }

    public List<Option> getOptions(String ... optionNames) throws XmlRpcFault {
        XmlRpcArray options = null;
        if (optionNames[0] != null) {
            options = new XmlRpcArray();
            for (String s : optionNames) {
                if (s == null) continue;
                options.add((Object)s);
            }
        }
        XmlRpcStruct r = options != null ? this.wp.getOptions(BLOGID, this.username, this.password, options) : this.wp.getOptions(BLOGID, this.username, this.password);
        return Wordpress.structToOptions(r);
    }

    public List<URL> getPingbacks(String url) throws XmlRpcFault {
        ArrayList<URL> result = null;
        XmlRpcArray r = this.pingbackExt.getPingbacks(url);
        result = new ArrayList<URL>();
        for (Object rec : r) {
            try {
                result.add(new URL((String)rec));
            }
            catch (MalformedURLException e) {
                logger.error("malformed url for pingback: {}", rec);
            }
        }
        return result;
    }

    public Post getPost(Integer postId) throws InsufficientRightsException, ObjectNotFoundException, XmlRpcFault {
        try {
            XmlRpcStruct r = this.wp.getPost(BLOGID, this.username, this.password, postId);
            Post result = new Post();
            result.fromXmlRpcStruct(r);
            return result;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public Map<String, String> getPostFormats() throws InsufficientRightsException, XmlRpcFault {
        return this.getPostFormats(false);
    }

    public Map<String, String> getPostFormats(boolean showSupported) throws InsufficientRightsException, XmlRpcFault {
        ArrayList<String> filtered = null;
        try {
            XmlRpcStruct r;
            if (!showSupported) {
                r = this.wp.getPostFormats(BLOGID, this.username, this.password);
            } else {
                XmlRpcArray filter = new XmlRpcArray();
                XmlRpcStruct ss = new XmlRpcStruct();
                ss.put((Object)"show-supported", (Object)"true");
                filter.add((Object)ss);
                r = this.wp.getPostFormats(BLOGID, this.username, this.password, ss);
                XmlRpcArray f = r.getArray((Object)"supported");
                filtered = new ArrayList<String>();
                for (Object fItem : f) {
                    filtered.add((String)fItem);
                }
                r = r.getStruct((Object)"all");
            }
            if (r != null) {
                HashMap<String, String> result = new HashMap<String, String>();
                for (Object s : r.keySet()) {
                    if (filtered == null) {
                        result.put((String)s, (String)r.get(s));
                        continue;
                    }
                    if (!filtered.contains(s)) continue;
                    result.put((String)s, (String)r.get(s));
                }
                return result;
            }
            return null;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 403: {
                    throw new InsufficientRightsException(e);
                }
            }
            throw e;
        }
    }

    public List<Post> getPosts() throws XmlRpcFault {
        return this.getPosts(null);
    }

    public List<Post> getPosts(FilterPost filter) throws XmlRpcFault {
        XmlRpcArray r = null;
        r = filter == null ? this.wp.getPosts(BLOGID, this.username, this.password) : this.wp.getPosts(BLOGID, this.username, this.password, filter.toXmlRpcStruct());
        return Wordpress.fillFromXmlRpcArray(r, Post.class, new Post());
    }

    public Map<String, String> getPostStatusList() throws InsufficientRightsException, XmlRpcFault {
        try {
            XmlRpcStruct r = this.wp.getPostStatusList(BLOGID, this.username, this.password);
            if (r != null) {
                HashMap<String, String> result = new HashMap<String, String>();
                for (Object s : r.keySet()) {
                    result.put((String)s, (String)r.get(s));
                }
                return result;
            }
            return null;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 403: {
                    throw new InsufficientRightsException(e);
                }
            }
            throw e;
        }
    }

    public PostType getPostType(String postTypeName) throws InsufficientRightsException, InvalidArgumentsException, XmlRpcFault {
        try {
            XmlRpcStruct r = this.wp.getPostType(BLOGID, this.username, this.password, postTypeName);
            PostType result = new PostType();
            result.fromXmlRpcStruct(r);
            return result;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 403: {
                    throw new InvalidArgumentsException(e);
                }
            }
            throw e;
        }
    }

    public List<PostType> getPostTypes() throws XmlRpcFault {
        return this.getPostTypes(null);
    }

    public List<PostType> getPostTypes(Map<String, Object> filter) throws XmlRpcFault {
        XmlRpcStruct r;
        if (filter == null) {
            r = this.wp.getPostTypes(BLOGID, this.username, this.password);
        } else {
            XmlRpcStruct postTypeFilter = new XmlRpcStruct();
            for (String k : filter.keySet()) {
                Object v = filter.get(k);
                if (v == null) continue;
                postTypeFilter.put((Object)k, v);
            }
            r = this.wp.getPostTypes(BLOGID, this.username, this.password, postTypeFilter);
        }
        ArrayList<PostType> result = new ArrayList<PostType>();
        for (String k : r.keySet()) {
            Object value = r.get((Object)k);
            PostType pt = new PostType();
            pt.fromXmlRpcStruct((XmlRpcStruct)value);
            result.add(pt);
        }
        return result;
    }

    public User getProfile() throws InsufficientRightsException, XmlRpcFault {
        try {
            XmlRpcStruct r = this.wp.getProfile(BLOGID, this.username, this.password);
            User user = new User();
            user.fromXmlRpcStruct(r);
            return user;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
            }
            throw e;
        }
    }

    public List<Taxonomy> getTaxonomies() throws XmlRpcFault {
        XmlRpcArray r = this.wp.getTaxonomies(BLOGID, this.username, this.password);
        return Wordpress.fillFromXmlRpcArray(r, Taxonomy.class, new Taxonomy());
    }

    public Taxonomy getTaxonomy(String taxonomy) throws InsufficientRightsException, InvalidArgumentsException, XmlRpcFault {
        try {
            XmlRpcStruct r = this.wp.getTaxonomy(BLOGID, this.username, this.password, taxonomy);
            Taxonomy t = new Taxonomy();
            t.fromXmlRpcStruct(r);
            return t;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 403: {
                    throw new InvalidArgumentsException(taxonomy);
                }
            }
            throw e;
        }
    }

    public Term getTerm(String taxonomy, Integer termId) throws InsufficientRightsException, InvalidArgumentsException, ObjectNotFoundException, XmlRpcFault {
        try {
            XmlRpcStruct r = this.wp.getTerm(BLOGID, this.username, this.password, taxonomy, termId);
            Term t = Term.builder().build();
            t.fromXmlRpcStruct(r);
            return t;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 403: {
                    throw new InvalidArgumentsException(taxonomy);
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public List<Term> getTerms(String taxonomy) throws InsufficientRightsException, InvalidArgumentsException, XmlRpcFault {
        return this.getTerms(taxonomy, null);
    }

    public List<Term> getTerms(String taxonomy, TermFilter filter) throws InsufficientRightsException, InvalidArgumentsException, XmlRpcFault {
        try {
            XmlRpcArray r = filter != null ? this.wp.getTerms(BLOGID, this.username, this.password, taxonomy, filter.toXmlRpcStruct()) : this.wp.getTerms(BLOGID, this.username, this.password, taxonomy);
            return Wordpress.fillFromXmlRpcArray(r, Term.class, Term.builder().build());
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 403: {
                    throw new InvalidArgumentsException(taxonomy);
                }
            }
            throw e;
        }
    }

    public User getUser(Integer userId) throws InsufficientRightsException, ObjectNotFoundException, XmlRpcFault {
        try {
            XmlRpcStruct r = this.wp.getUser(BLOGID, this.username, this.password, userId);
            User user = new User();
            user.fromXmlRpcStruct(r);
            return user;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public List<User> getUsers() throws InsufficientRightsException, InvalidArgumentsException, XmlRpcFault {
        return this.getUsers(null);
    }

    public List<User> getUsers(FilterUser filter) throws InsufficientRightsException, InvalidArgumentsException, XmlRpcFault {
        try {
            XmlRpcArray r;
            if (filter == null) {
                r = this.wp.getUsers(BLOGID, this.username, this.password);
            } else {
                XmlRpcStruct f = filter.buildWithNonNullValues();
                r = this.wp.getUsers(BLOGID, this.username, this.password, f);
            }
            return Wordpress.fillFromXmlRpcArray(r, User.class, new User());
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 403: {
                    if (filter != null) {
                        throw new InvalidArgumentsException(filter.getRole());
                    }
                    throw new InvalidArgumentsException(e);
                }
            }
            throw e;
        }
    }

    public List<UserBlog> getUsersBlogs() throws XmlRpcFault {
        XmlRpcArray r = this.wp.getUsersBlogs(this.username, this.password);
        return Wordpress.fillFromXmlRpcArray(r, UserBlog.class, new UserBlog());
    }

    private void initMetaWebLog() throws MalformedURLException {
        URL url = new URL(this.xmlRpcUrl);
        this.wp = (WordpressBridge)XmlRpcProxy.createProxy((URL)url, (String)"wp", (Class[])new Class[]{WordpressBridge.class}, (boolean)true);
        this.pingback = (PingbackBridge)XmlRpcProxy.createProxy((URL)url, (String)"pingback", (Class[])new Class[]{PingbackBridge.class}, (boolean)true);
        this.pingbackExt = (PingbackExtensionsBridge)XmlRpcProxy.createProxy((URL)url, (String)"pingback.extensions", (Class[])new Class[]{PingbackExtensionsBridge.class}, (boolean)true);
    }

    public Integer newComment(Integer post_id, Integer comment_parent, String content, String author, String author_url, String author_email) throws InsufficientRightsException, ObjectNotFoundException, XmlRpcFault {
        try {
            XmlRpcStruct comment = new XmlRpcStruct();
            if (comment_parent != null) {
                comment.put((Object)"comment_parent", (Object)comment_parent);
            }
            comment.put((Object)"content", (Object)content);
            if (author != null) {
                comment.put((Object)"author", (Object)author);
            }
            if (author_url != null) {
                comment.put((Object)"author_url", (Object)author_url);
            }
            if (author_email != null) {
                comment.put((Object)"author_email", (Object)author_email);
            }
            Integer comment_id = this.wp.newComment(BLOGID, this.username, this.password, post_id, comment);
            return comment_id;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 403: {
                    throw new InsufficientRightsException(e);
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public Integer newPost(Post post) throws InsufficientRightsException, InvalidArgumentsException, ObjectNotFoundException, XmlRpcFault {
        if (post.getPost_thumbnail() != null) {
            // empty if block
        }
        try {
            List<Term> oldTerms = post.getTerms();
            XmlRpcStruct postX = post.toXmlRpcStruct();
            if (oldTerms != null) {
                XmlRpcStruct newTerms = new XmlRpcStruct();
                for (Term term : post.getTerms()) {
                    XmlRpcArray ts = (XmlRpcArray)newTerms.get((Object)term.getTaxonomy());
                    if (ts == null) {
                        XmlRpcArray tXs = new XmlRpcArray();
                        tXs.add((Object)term.getTerm_id());
                        newTerms.put((Object)term.getTaxonomy(), (Object)tXs);
                        continue;
                    }
                    ts.add((Object)term.getTerm_id());
                }
                postX.put((Object)"terms", (Object)newTerms);
            }
            return Integer.valueOf(this.wp.newPost(BLOGID, this.username, this.password, postX));
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 403: {
                    throw new InvalidArgumentsException(e);
                }
                case 404: {
                    throw new ObjectNotFoundException(e);
                }
            }
            throw e;
        }
    }

    public Integer newTerm(Term term) throws InsufficientRightsException, InvalidArgumentsException, XmlRpcFault {
        try {
            String r = this.wp.newTerm(BLOGID, this.username, this.password, term.toXmlRpcStruct());
            return Integer.valueOf(r);
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 403: {
                    throw new InvalidArgumentsException(e);
                }
            }
            throw e;
        }
    }

    public String ping(String pagelinkedfrom, String pagelinkedto) throws XmlRpcFault {
        return this.pingback.ping(pagelinkedfrom, pagelinkedto);
    }

    public Option setOption(Option option) throws InsufficientRightsException, XmlRpcFault {
        List<Option> r = this.setOptions(option);
        return r == null || r.size() == 0 ? null : r.get(0);
    }

    public List<Option> setOptions(Option ... options) throws InsufficientRightsException, XmlRpcFault {
        try {
            XmlRpcStruct opts = new XmlRpcStruct();
            for (Option o : options) {
                if (o == null) continue;
                opts.put((Object)o.getName(), (Object)o.getValue());
            }
            XmlRpcArray optsArr = new XmlRpcArray();
            optsArr.add((Object)opts);
            XmlRpcStruct r = this.wp.setOptions(BLOGID, this.username, this.password, opts);
            return Wordpress.structToOptions(r);
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 403: {
                    throw new InsufficientRightsException(e);
                }
            }
            throw e;
        }
    }

    public MediaItemUploadResult uploadFile(InputStream media, String fileName) throws InsufficientRightsException, FileUploadException, XmlRpcFault, IOException {
        return this.uploadFile(media, fileName, null);
    }

    public MediaItemUploadResult uploadFile(InputStream media, String fileName, Boolean overwrite) throws InsufficientRightsException, FileUploadException, XmlRpcFault, IOException {
        return this.uploadFile(media, fileName, overwrite, null);
    }

    public MediaItemUploadResult uploadFile(InputStream media, String fileName, Boolean overwrite, Integer postId) throws InsufficientRightsException, FileUploadException, XmlRpcFault, IOException {
        try {
            XmlRpcStruct data = new XmlRpcStruct();
            File tempFile = File.createTempFile("mediauploadwpj", fileName);
            tempFile.deleteOnExit();
            Files.copy(media, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            String mimeType = new MimetypesFileTypeMap().getContentType(fileName);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            try (FileInputStream mediaTemp = new FileInputStream(tempFile);){
                int len = ((InputStream)mediaTemp).read(buffer);
                while (len != -1) {
                    out.write(buffer, 0, len);
                    len = ((InputStream)mediaTemp).read(buffer);
                }
            }
            tempFile.delete();
            data.put((Object)"name", (Object)fileName);
            data.put((Object)"type", (Object)mimeType);
            data.put((Object)"bits", (Object)out.toByteArray());
            if (postId != null) {
                data.put((Object)"post_id", (Object)postId);
            }
            if (overwrite != null) {
                data.put((Object)"overwrite", (Object)overwrite);
            }
            XmlRpcStruct r = this.wp.uploadFile(BLOGID, this.username, this.password, data);
            MediaItemUploadResult result = new MediaItemUploadResult();
            result.fromXmlRpcStruct(r);
            return result;
        }
        catch (XmlRpcFault e) {
            int err = e.getErrorCode();
            switch (err) {
                case 401: {
                    throw new InsufficientRightsException(e);
                }
                case 500: {
                    throw new FileUploadException(e);
                }
            }
            throw e;
        }
    }
}

