/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.api.controller.base;

import java.lang.reflect.ParameterizedType;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.authorize.Environment;
import net.authorize.api.contract.v1.ANetApiRequest;
import net.authorize.api.contract.v1.ANetApiResponse;
import net.authorize.api.contract.v1.ErrorResponse;
import net.authorize.api.contract.v1.ImpersonationAuthenticationType;
import net.authorize.api.contract.v1.MerchantAuthenticationType;
import net.authorize.api.contract.v1.MessageTypeEnum;
import net.authorize.api.contract.v1.MessagesType;
import net.authorize.api.controller.base.IApiOperation;
import net.authorize.util.HttpUtility;
import net.authorize.util.LogHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApiOperationBase<Q extends ANetApiRequest, S extends ANetApiResponse>
implements IApiOperation<Q, S> {
    protected static Log logger = LogFactory.getLog(ApiOperationBase.class);
    private static Environment environment = null;
    private static MerchantAuthenticationType merchantAuthentication = null;
    private Q apiRequest = null;
    private S apiResponse = null;
    Class<Q> requestClass = null;
    Class<S> responseClass = null;
    private ANetApiResponse errorResponse = null;
    final String nullEnvironmentErrorMessage = "Environment not set. Set environment using setter or use overloaded method to pass appropriate environment";
    protected List<String> results = null;
    protected MessageTypeEnum resultCode = null;

    protected ApiOperationBase(Q apiRequest) {
        if (null == apiRequest) {
            logger.error(apiRequest);
            throw new NullPointerException("Input request cannot be null");
        }
        if (null != this.getApiResponse()) {
            logger.error(this.getApiResponse());
            throw new IllegalStateException("Response should be null");
        }
        this.requestClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.responseClass = this.getResponseType();
        this.setApiRequest(apiRequest);
        this.setClientId();
        logger.debug((Object)String.format("Creating instance for request:'%s' and response:'%s'", this.requestClass, this.responseClass));
        logger.debug((Object)String.format("Request:'%s'", apiRequest));
        this.validate();
    }

    protected Q getApiRequest() {
        return this.apiRequest;
    }

    protected void setApiRequest(Q apiRequest) {
        this.apiRequest = apiRequest;
    }

    protected void setClientId() {
        ((ANetApiRequest)this.apiRequest).setClientId(this.getClientId());
    }

    @Override
    public S getApiResponse() {
        return this.apiResponse;
    }

    private void setApiResponse(S apiResponse) {
        this.apiResponse = apiResponse;
    }

    @Override
    public ANetApiResponse getErrorResponse() {
        return this.errorResponse;
    }

    private void setErrorResponse(ANetApiResponse errorResponse) {
        this.errorResponse = errorResponse;
    }

    public static Environment getEnvironment() {
        return environment;
    }

    public static void setEnvironment(Environment environment) {
        ApiOperationBase.environment = environment;
    }

    public static MerchantAuthenticationType getMerchantAuthentication() {
        return merchantAuthentication;
    }

    public static void setMerchantAuthentication(MerchantAuthenticationType merchantAuthentication) {
        ApiOperationBase.merchantAuthentication = merchantAuthentication;
    }

    @Override
    public S executeWithApiResponse() {
        return this.executeWithApiResponse(ApiOperationBase.getEnvironment());
    }

    @Override
    public S executeWithApiResponse(Environment environment) {
        this.execute(environment);
        return this.getApiResponse();
    }

    @Override
    public void execute() {
        if (null == ApiOperationBase.getEnvironment()) {
            throw new InvalidParameterException("Environment not set. Set environment using setter or use overloaded method to pass appropriate environment");
        }
        this.execute(ApiOperationBase.getEnvironment());
    }

    @Override
    public void execute(Environment environment) {
        this.beforeExecute();
        logger.debug((Object)String.format("Executing Request:'%s'", this.getApiRequest()));
        if (null == environment) {
            throw new InvalidParameterException("Environment not set. Set environment using setter or use overloaded method to pass appropriate environment");
        }
        ANetApiResponse httpApiResponse = HttpUtility.postData(environment, this.getApiRequest(), this.responseClass);
        if (null != httpApiResponse) {
            logger.debug((Object)String.format("Received Response:'%s' for request:'%s'", httpApiResponse, this.getApiRequest()));
            if (httpApiResponse.getClass() == this.responseClass) {
                ANetApiResponse response = httpApiResponse;
                this.setApiResponse(response);
                logger.debug((Object)String.format("Setting response: '%s'", response));
            } else if (httpApiResponse.getClass() == ErrorResponse.class) {
                this.setErrorResponse(httpApiResponse);
                logger.debug((Object)String.format("Received ErrorResponse:'%s'", httpApiResponse));
            } else {
                this.setErrorResponse(httpApiResponse);
                logger.error((Object)String.format("Invalid response:'%s'", httpApiResponse));
            }
            this.setResultStatus();
        } else {
            logger.debug((Object)String.format("Got a 'null' Response for request:'%s'%s", this.getApiRequest(), LogHelper.LineSeparator));
        }
        this.afterExecute();
    }

    @Override
    public MessageTypeEnum getResultCode() {
        return this.resultCode;
    }

    private void setResultStatus() {
        this.results = new ArrayList<String>();
        MessagesType messageTypes = this.getResultMessage();
        if (null != messageTypes) {
            this.resultCode = messageTypes.getResultCode();
        }
        if (null != messageTypes) {
            for (MessagesType.Message amessage : messageTypes.getMessage()) {
                this.results.add(String.format("%s:%s", amessage.getCode(), amessage.getText()));
            }
        }
    }

    @Override
    public List<String> getResults() {
        return this.results;
    }

    private MessagesType getResultMessage() {
        MessagesType messageTypes = null;
        if (null != this.getErrorResponse()) {
            messageTypes = this.getErrorResponse().getMessages();
        } else if (null != this.getApiResponse()) {
            messageTypes = ((ANetApiResponse)this.getApiResponse()).getMessages();
        }
        return messageTypes;
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    protected abstract void validateRequest();

    protected abstract Class<S> getResponseType();

    private void validate() {
        Q request = this.getApiRequest();
        this.validateAndSetMerchantAuthentication();
        MerchantAuthenticationType merchantAuthenticationType = ((ANetApiRequest)request).getMerchantAuthentication();
        if (null != merchantAuthenticationType.getSessionToken()) {
            throw new IllegalArgumentException("SessionToken needs to be null");
        }
        if (null != merchantAuthenticationType.getPassword()) {
            throw new IllegalArgumentException("Password needs to be null");
        }
        if (null != merchantAuthenticationType.getMobileDeviceId()) {
            throw new IllegalArgumentException("MobileDeviceId needs to be null");
        }
        ImpersonationAuthenticationType impersonationAuthenticationType = merchantAuthenticationType.getImpersonationAuthentication();
        if (null != impersonationAuthenticationType) {
            throw new IllegalArgumentException("ImpersonationAuthenticationType needs to be null");
        }
        this.validateRequest();
    }

    private void validateAndSetMerchantAuthentication() {
        Q request = this.getApiRequest();
        if (null == ((ANetApiRequest)request).getMerchantAuthentication()) {
            if (null != ApiOperationBase.getMerchantAuthentication()) {
                ((ANetApiRequest)request).setMerchantAuthentication(ApiOperationBase.getMerchantAuthentication());
            } else {
                throw new NullPointerException("MerchantAuthentication cannot be null");
            }
        }
    }

    public String getClientId() {
        return "sdk-java-1.9.3";
    }
}

