/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.sim;

import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.authorize.Merchant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Fingerprint {
    private static Log logger = LogFactory.getLog(Fingerprint.class);
    private long sequence;
    private long timeStamp;
    private String fingerprintHash;

    private Fingerprint() {
    }

    public static Fingerprint createFingerprint(String loginID, String transactionKey, long sequence, String amount) {
        Fingerprint fingerprint = new Fingerprint();
        Random generator = new Random();
        fingerprint.sequence = Long.parseLong(sequence + "" + generator.nextInt(1000));
        fingerprint.timeStamp = System.currentTimeMillis() / 1000L;
        try {
            SecretKeySpec key = new SecretKeySpec(transactionKey.getBytes(), "HmacMD5");
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(key);
            String inputstring = loginID + "^" + fingerprint.sequence + "^" + fingerprint.timeStamp + "^" + amount + "^";
            byte[] result = mac.doFinal(inputstring.getBytes());
            StringBuffer strbuf = new StringBuffer(result.length * 2);
            for (int i = 0; i < result.length; ++i) {
                if ((result[i] & 0xFF) < 16) {
                    strbuf.append("0");
                }
                strbuf.append(Long.toString(result[i] & 0xFF, 16));
            }
            fingerprint.fingerprintHash = strbuf.toString();
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error((Object)"Fingerprint creation failed.", (Throwable)nsae);
        }
        catch (InvalidKeyException ike) {
            logger.error((Object)"Fingerprint creation failed.", (Throwable)ike);
        }
        return fingerprint;
    }

    public static Fingerprint createFingerprint(Merchant merchant, long sequence, BigDecimal amount) {
        Fingerprint fingerprint = new Fingerprint();
        if (merchant != null && amount != null) {
            fingerprint = Fingerprint.createFingerprint(merchant.getLogin(), merchant.getTransactionKey(), sequence, amount.setScale(2, 4).toPlainString());
        }
        return fingerprint;
    }

    public long getSequence() {
        return Math.abs(this.sequence);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getFingerprintHash() {
        return this.fingerprintHash;
    }
}

