/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectFormatter
implements Formatter {
    private Class<?> cls;
    private transient PropertyInfo[] props;

    public ObjectFormatter(Class<?> clazz) {
        this.cls = clazz;
    }

    @Override
    public boolean accept(Object object) {
        return object != null && !object.getClass().isPrimitive();
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public void format(JSON.Context context, Object object, Object object2, OutputSource outputSource) throws Exception {
        if (this.props == null) {
            this.props = ObjectFormatter.getGetProperties(context, this.cls);
        }
        outputSource.append('{');
        int n = 0;
        String string = null;
        try {
            Class<?> clazz = null;
            Formatter formatter = null;
            for (PropertyInfo propertyInfo : this.props) {
                string = propertyInfo.getName();
                Object object3 = propertyInfo.get(object2);
                if (object3 == object || context.isSuppressNull() && object3 == null) continue;
                if (n != 0) {
                    outputSource.append(',');
                }
                if (context.isPrettyPrint()) {
                    outputSource.append('\n');
                    context.appendIndent(outputSource, context.getDepth() + 1);
                }
                StringFormatter.serialize(context, string.toString(), outputSource);
                outputSource.append(':');
                if (context.isPrettyPrint()) {
                    outputSource.append(' ');
                }
                JSONHint jSONHint = propertyInfo.getReadAnnotation(JSONHint.class);
                context.enter(string, jSONHint);
                string = null;
                object3 = context.preformatInternal(object3);
                if (object3 == null) {
                    NullFormatter.INSTANCE.format(context, object, object3, outputSource);
                } else if (jSONHint == null) {
                    if (object3.getClass() == clazz) {
                        formatter.format(context, object, object3, outputSource);
                    } else {
                        formatter = context.formatInternal(object3, outputSource);
                        clazz = object3.getClass();
                    }
                } else {
                    context.formatInternal(object3, outputSource);
                }
                context.exit();
                ++n;
            }
        }
        catch (Exception exception) {
            if (string != null) {
                context.enter(string, null);
            }
            throw exception;
        }
        if (context.isPrettyPrint() && n > 0) {
            outputSource.append('\n');
            context.appendIndent(outputSource, context.getDepth() + 1);
        }
        outputSource.append('}');
    }

    /*
     * WARNING - void declaration
     */
    static PropertyInfo[] getGetProperties(JSON.Context context, Class<?> clazz) {
        int n;
        Object object;
        Object object2;
        AccessibleObject accessibleObject;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (PropertyInfo propertyInfo : BeanInfo.get(clazz).getProperties()) {
            void object32;
            accessibleObject = propertyInfo.getField();
            if (accessibleObject == null || context.ignoreInternal(clazz, (Member)((Object)accessibleObject))) continue;
            object2 = ((Field)accessibleObject).getAnnotation(JSONHint.class);
            object = null;
            n = propertyInfo.getOrdinal();
            if (object2 != null) {
                if (object2.ignore()) continue;
                n = object2.ordinal();
                if (object2.name().length() != 0) {
                    object = object2.name();
                }
            }
            if (object == null) {
                object = context.normalizeInternal(propertyInfo.getName());
                if (context.getPropertyStyle() != null) {
                    object = context.getPropertyStyle().to((String)object);
                }
            }
            if (!((String)object).equals(propertyInfo.getName()) || n != propertyInfo.getOrdinal() || accessibleObject != propertyInfo.getReadMember()) {
                PropertyInfo propertyInfo2 = new PropertyInfo(propertyInfo.getBeanClass(), (String)object, propertyInfo.getField(), null, null, propertyInfo.isStatic(), n);
            }
            if (object32.getReadMethod() != null) {
                object32.getReadMethod().setAccessible(true);
            } else if (object32.getField() != null) {
                object32.getField().setAccessible(true);
            }
            hashMap.put(object, object32);
        }
        for (PropertyInfo propertyInfo : BeanInfo.get(clazz).getProperties()) {
            accessibleObject = propertyInfo.getReadMethod();
            if (accessibleObject == null || context.ignoreInternal(clazz, (Member)((Object)accessibleObject))) continue;
            object2 = ((Method)accessibleObject).getAnnotation(JSONHint.class);
            object = null;
            n = propertyInfo.getOrdinal();
            if (object2 != null) {
                if (object2.ignore()) continue;
                n = object2.ordinal();
                if (object2.name().length() != 0) {
                    object = object2.name();
                }
            }
            if (object == null) {
                object = context.normalizeInternal(propertyInfo.getName());
                if (context.getPropertyStyle() != null) {
                    object = context.getPropertyStyle().to((String)object);
                }
            }
            if (!((String)object).equals(propertyInfo.getName()) || n != propertyInfo.getOrdinal()) {
                hashMap.put(object, new PropertyInfo(propertyInfo.getBeanClass(), (String)object, null, propertyInfo.getReadMethod(), null, propertyInfo.isStatic(), n));
                continue;
            }
            hashMap.put(object, propertyInfo);
        }
        Collection collection = hashMap.values();
        Object[] objectArray = new PropertyInfo[collection.size()];
        int n2 = 0;
        object2 = collection.iterator();
        while (object2.hasNext()) {
            object = (PropertyInfo)object2.next();
            objectArray[n2++] = object;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }
}

