/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.EnumConverter;
import net.arnx.jsonic.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StringSerializableConverter
implements Converter {
    public static final StringSerializableConverter INSTANCE = new StringSerializableConverter();

    StringSerializableConverter() {
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return true;
    }

    @Override
    public Object convert(JSON.Context context, Object object, Class<?> clazz, Type type) throws Exception {
        if (clazz.isEnum()) {
            return EnumConverter.INSTANCE.convert(context, object, clazz, type);
        }
        if (object instanceof String) {
            if (clazz == String.class) {
                return object.toString();
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(String.class);
                constructor.setAccessible(true);
                return constructor.newInstance(object.toString());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        if (object != null) {
            throw new UnsupportedOperationException("Cannot convert " + object.getClass() + " to " + type);
        }
        return null;
    }
}

