/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class ElementNodeFormatter
implements Formatter {
    public static final ElementNodeFormatter INSTANCE = new ElementNodeFormatter();
    private static final Class<?>[] targets = new Class[]{Document.class, Element.class};

    ElementNodeFormatter() {
    }

    public boolean accept(Object object) {
        for (Class<?> clazz : targets) {
            if (object == null || !clazz.isAssignableFrom(object.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isStruct() {
        return true;
    }

    public void format(JSON.Context context, Object object, Object object2, OutputSource outputSource) throws Exception {
        if (object2 instanceof Document) {
            this.formatElement(context, object, ((Document)object2).getDocumentElement(), outputSource);
        } else {
            this.formatElement(context, object, (Element)object2, outputSource);
        }
    }

    public boolean formatElement(JSON.Context context, Object object, Object object2, OutputSource outputSource) throws Exception {
        Object object3;
        Element element = (Element)object2;
        outputSource.append('[');
        StringFormatter.serialize(context, element.getTagName(), outputSource);
        outputSource.append(',');
        if (context.isPrettyPrint()) {
            outputSource.append('\n');
            context.appendIndent(outputSource, context.getDepth() + 1);
        }
        outputSource.append('{');
        if (element.hasAttributes()) {
            object3 = element.getAttributes();
            for (int i = 0; i < object3.getLength(); ++i) {
                Node node;
                if (i != 0) {
                    outputSource.append(',');
                }
                if (context.isPrettyPrint() && object3.getLength() > 1) {
                    outputSource.append('\n');
                    for (int j = 0; j < context.getDepth() + 2; ++j) {
                        outputSource.append('\t');
                    }
                }
                if (!((node = object3.item(i)) instanceof Attr)) continue;
                StringFormatter.serialize(context, node.getNodeName(), outputSource);
                outputSource.append(':');
                if (context.isPrettyPrint()) {
                    outputSource.append(' ');
                }
                StringFormatter.serialize(context, node.getNodeValue(), outputSource);
            }
            if (context.isPrettyPrint() && object3.getLength() > 1) {
                outputSource.append('\n');
                context.appendIndent(outputSource, context.getDepth() + 1);
            }
        }
        outputSource.append('}');
        if (element.hasChildNodes()) {
            object3 = element.getChildNodes();
            JSONHint jSONHint = context.getHint();
            for (int i = 0; i < object3.getLength(); ++i) {
                Object object4 = object3.item(i);
                if (!(object4 instanceof Element) && (!(object4 instanceof CharacterData) || object4 instanceof Comment)) continue;
                outputSource.append(',');
                if (context.isPrettyPrint()) {
                    outputSource.append('\n');
                    context.appendIndent(outputSource, context.getDepth() + 1);
                }
                context.enter(i + 2, jSONHint);
                object4 = context.preformatInternal(object4);
                context.formatInternal(object4, outputSource);
                context.exit();
            }
        }
        if (context.isPrettyPrint()) {
            outputSource.append('\n');
            context.appendIndent(outputSource, context.getDepth());
        }
        outputSource.append(']');
        return true;
    }
}

