/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.text.NumberFormat;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;

final class DoubleArrayFormatter
implements Formatter {
    public static final DoubleArrayFormatter INSTANCE = new DoubleArrayFormatter();

    DoubleArrayFormatter() {
    }

    public boolean format(JSON.Context context, Object object, Object object2, OutputSource outputSource) throws Exception {
        NumberFormat numberFormat = context.getNumberFormat();
        double[] dArray = (double[])object2;
        outputSource.append('[');
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isInfinite(dArray[i])) {
                if (context.getMode() != JSON.Mode.SCRIPT) {
                    outputSource.append('\"');
                    outputSource.append(Double.toString(dArray[i]));
                    outputSource.append('\"');
                } else if (Double.isNaN(dArray[i])) {
                    outputSource.append("Number.NaN");
                } else {
                    outputSource.append("Number.");
                    outputSource.append(dArray[i] > 0.0 ? "POSITIVE" : "NEGATIVE");
                    outputSource.append("_INFINITY");
                }
            } else if (numberFormat != null) {
                StringFormatter.serialize(context, numberFormat.format(dArray[i]), outputSource);
            } else {
                outputSource.append(String.valueOf(dArray[i]));
            }
            if (i == dArray.length - 1) continue;
            outputSource.append(',');
            if (!context.isPrettyPrint()) continue;
            outputSource.append(' ');
        }
        outputSource.append(']');
        return true;
    }
}

