/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.plugins.vcs;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import name.remal.gradle_plugins.dsl.BuildTask;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_TaskKt;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_Task_logging_generatedKt;
import name.remal.gradle_plugins.dsl.extensions.Org_gradle_api_plugins_ExtensionAwareKt;
import name.remal.gradle_plugins.plugins.vcs.AutoVcsVersionExtension;
import name.remal.gradle_plugins.plugins.vcs.VcsOperationsExtension;
import name.remal.gradle_plugins.plugins.vcs.VcsOperationsPlugin;
import name.remal.gradle_plugins.plugins.vcs.VcsTagExistsException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@BuildTask
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0015R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R$\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00048W@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lname/remal/gradle_plugins/plugins/vcs/FailIfProjectVersionTagExists;", "Lorg/gradle/api/DefaultTask;", "()V", "_tagNamePrefix", "", "tagName", "getTagName", "()Ljava/lang/String;", "value", "tagNamePrefix", "getTagNamePrefix", "setTagNamePrefix", "(Ljava/lang/String;)V", "checkTag", "", "gradle-plugins"})
public class FailIfProjectVersionTagExists
extends DefaultTask {
    private String _tagNamePrefix;

    @Input
    @Optional
    @NotNull
    public String getTagNamePrefix() {
        String string;
        String string2 = this._tagNamePrefix;
        if (string2 == null) {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            Object object = (AutoVcsVersionExtension)project.getExtensions().findByType(AutoVcsVersionExtension.class);
            string2 = object != null && (object = ((AutoVcsVersionExtension)object).getVersionTagPrefixes()) != null ? (String)CollectionsKt.firstOrNull((List)object) : (string = null);
        }
        if (string2 == null) {
            string = "version-";
        }
        return string;
    }

    public void setTagNamePrefix(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this._tagNamePrefix = value;
    }

    @Input
    @Optional
    @Nullable
    public String getTagName() {
        StringBuilder stringBuilder = new StringBuilder().append(this.getTagNamePrefix());
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return stringBuilder.append(project.getVersion()).toString();
    }

    @TaskAction
    protected void checkTag() {
        String tagName = this.getTagName();
        Org_gradle_api_Task_logging_generatedKt.logDebug((Task)this, (String)"Checking if '{}' tag exists", (Object[])new Object[]{tagName});
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        VcsOperationsExtension vcsOperations2 = (VcsOperationsExtension)Org_gradle_api_plugins_ExtensionAwareKt.get((ExtensionAware)((ExtensionAware)project), VcsOperationsExtension.class);
        if (CollectionsKt.contains((Iterable)vcsOperations2.getAllTagNames(), (Object)tagName)) {
            throw (Throwable)new VcsTagExistsException("Tag '" + tagName + "' already exists");
        }
        this.setDidWork(true);
    }

    public FailIfProjectVersionTagExists() {
        Org_gradle_api_TaskKt.requirePlugin((Task)this, VcsOperationsPlugin.class);
    }
}

