/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.okhttp3;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public enum TlsVersion {
    TLS_1_3("TLSv1.3"),
    TLS_1_2("TLSv1.2"),
    TLS_1_1("TLSv1.1"),
    TLS_1_0("TLSv1"),
    SSL_3_0("SSLv3");

    final String javaName;

    private TlsVersion(String javaName) {
        this.javaName = javaName;
    }

    public static TlsVersion forJavaName(String javaName) {
        switch (javaName) {
            case "TLSv1.3": {
                return TLS_1_3;
            }
            case "TLSv1.2": {
                return TLS_1_2;
            }
            case "TLSv1.1": {
                return TLS_1_1;
            }
            case "TLSv1": {
                return TLS_1_0;
            }
            case "SSLv3": {
                return SSL_3_0;
            }
        }
        throw new IllegalArgumentException("Unexpected TLS version: " + javaName);
    }

    static List<TlsVersion> forJavaNames(String ... tlsVersions) {
        ArrayList<TlsVersion> result2 = new ArrayList<TlsVersion>(tlsVersions.length);
        for (String tlsVersion : tlsVersions) {
            result2.add(TlsVersion.forJavaName(tlsVersion));
        }
        return Collections.unmodifiableList(result2);
    }

    public String javaName() {
        return this.javaName;
    }
}

