/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.x.io;

import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.core.conf.PropertyDefinitions;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.io.ExportControlled;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.mysqla.io.MysqlaSocketConnection;
import com.mysql.cj.x.io.AsyncMessageReader;
import com.mysql.cj.x.io.AsyncMessageWriter;
import com.mysql.cj.x.io.SyncMessageReader;
import com.mysql.cj.x.io.SyncMessageWriter;
import com.mysql.cj.x.io.TlsDecryptingByteChannel;
import com.mysql.cj.x.io.TlsEncryptingByteChannel;
import com.mysql.cj.x.io.XProtocol;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class XProtocolFactory {
    public static XProtocol getInstance(String host, int port, PropertySet propertySet) {
        if (propertySet.getBooleanReadableProperty("xdevapi.useAsyncProtocol").getValue().booleanValue()) {
            return XProtocolFactory.getAsyncInstance(host, port, propertySet);
        }
        MysqlaSocketConnection socketConnection = new MysqlaSocketConnection();
        Properties socketFactoryProperties = new Properties();
        socketConnection.connect(host, port, socketFactoryProperties, propertySet, null, null, 0);
        SyncMessageReader messageReader = new SyncMessageReader(socketConnection.getMysqlInput());
        SyncMessageWriter messageWriter = new SyncMessageWriter(socketConnection.getMysqlOutput());
        return new XProtocol(messageReader, messageWriter, socketConnection.getMysqlSocket(), propertySet);
    }

    public static XProtocol getAsyncInstance(String host, int port, PropertySet propertySet) {
        try {
            String[] TLS_PROTOCOLS;
            String[] stringArray;
            String enabledTLSProtocols;
            boolean overrideCiphers;
            AsynchronousSocketChannel channel = AsynchronousSocketChannel.open();
            channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)131072);
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)131072);
            Future<Void> connectPromise = channel.connect(new InetSocketAddress(host, port));
            connectPromise.get();
            AsyncMessageReader messageReader = new AsyncMessageReader(propertySet, channel);
            messageReader.start();
            AsyncMessageWriter messageWriter = new AsyncMessageWriter(channel);
            XProtocol protocol = new XProtocol(messageReader, messageWriter, channel, propertySet);
            PropertyDefinitions.SslMode sslMode = (PropertyDefinitions.SslMode)((Object)propertySet.getEnumReadableProperty("xdevapi.ssl-mode").getValue());
            boolean verifyServerCert = sslMode == PropertyDefinitions.SslMode.VERIFY_CA || sslMode == PropertyDefinitions.SslMode.VERIFY_IDENTITY;
            String trustStoreUrl = propertySet.getStringReadableProperty("xdevapi.ssl-truststore").getValue();
            if (!verifyServerCert && !StringUtils.isNullOrEmpty(trustStoreUrl)) {
                StringBuilder msg = new StringBuilder("Incompatible security settings. The property '");
                msg.append("xdevapi.ssl-truststore").append("' requires '");
                msg.append("xdevapi.ssl-mode").append("' as '");
                msg.append((Object)PropertyDefinitions.SslMode.VERIFY_CA).append("' or '");
                msg.append((Object)PropertyDefinitions.SslMode.VERIFY_IDENTITY).append("'.");
                throw new CJCommunicationsException(msg.toString());
            }
            if (sslMode == PropertyDefinitions.SslMode.DISABLED) {
                return protocol;
            }
            if (!protocol.hasCapability("tls")) {
                throw new CJCommunicationsException("A secure connection is required but the server is not configured with SSL.");
            }
            messageReader.stopAfterNextMessage();
            protocol.setCapability("tls", true);
            String trustStoreType = null;
            String trustStorePassword = null;
            if (verifyServerCert) {
                trustStoreType = propertySet.getStringReadableProperty("xdevapi.ssl-truststore-type").getValue();
                trustStorePassword = propertySet.getStringReadableProperty("xdevapi.ssl-truststore-password").getValue();
                if (StringUtils.isNullOrEmpty(trustStoreUrl)) {
                    trustStoreUrl = System.getProperty("javax.net.ssl.trustStore");
                    trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                    trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
                    if (StringUtils.isNullOrEmpty(trustStoreType)) {
                        trustStoreType = propertySet.getStringReadableProperty("xdevapi.ssl-truststore-type").getInitialValue();
                    }
                    if (!StringUtils.isNullOrEmpty(trustStoreUrl)) {
                        try {
                            new URL(trustStoreUrl);
                        }
                        catch (MalformedURLException e) {
                            trustStoreUrl = "file:" + trustStoreUrl;
                        }
                    }
                }
                if (StringUtils.isNullOrEmpty(trustStoreUrl)) {
                    throw new CJCommunicationsException("No truststore provided to verify the Server certificate.");
                }
            }
            String keyStoreUrl = propertySet.getStringReadableProperty("clientCertificateKeyStoreUrl").getValue();
            String keyStoreType = propertySet.getStringReadableProperty("clientCertificateKeyStoreType").getValue();
            String keyStorePassword = propertySet.getStringReadableProperty("clientCertificateKeyStorePassword").getValue();
            if (StringUtils.isNullOrEmpty(keyStoreUrl)) {
                keyStoreUrl = System.getProperty("javax.net.ssl.keyStore");
                keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
                keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
                if (StringUtils.isNullOrEmpty(keyStoreType)) {
                    keyStoreType = propertySet.getStringReadableProperty("clientCertificateKeyStoreType").getInitialValue();
                }
                if (!StringUtils.isNullOrEmpty(keyStoreUrl)) {
                    try {
                        new URL(keyStoreUrl);
                    }
                    catch (MalformedURLException e) {
                        keyStoreUrl = "file:" + keyStoreUrl;
                    }
                }
            }
            SSLContext sslContext = ExportControlled.getSSLContext(keyStoreUrl, keyStoreType, keyStorePassword, trustStoreUrl, trustStoreType, trustStorePassword, false, verifyServerCert, sslMode == PropertyDefinitions.SslMode.VERIFY_IDENTITY ? host : null, null);
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            String enabledSSLCipherSuites = propertySet.getStringReadableProperty("enabledSSLCipherSuites").getValue();
            boolean bl = overrideCiphers = enabledSSLCipherSuites != null && enabledSSLCipherSuites.length() > 0;
            if (overrideCiphers) {
                ArrayList<String> allowedCiphers = new ArrayList<String>();
                List<String> availableCiphers = Arrays.asList(sslEngine.getEnabledCipherSuites());
                for (String cipher : enabledSSLCipherSuites.split("\\s*,\\s*")) {
                    if (!availableCiphers.contains(cipher)) continue;
                    allowedCiphers.add(cipher);
                }
                sslEngine.setEnabledCipherSuites(allowedCiphers.toArray(new String[0]));
            }
            if ((enabledTLSProtocols = propertySet.getStringReadableProperty("enabledTLSProtocols").getValue()) != null && enabledTLSProtocols.length() > 0) {
                stringArray = enabledTLSProtocols.split("\\s*,\\s*");
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "TLSv1.1";
                stringArray = stringArray2;
                stringArray2[1] = "TLSv1";
            }
            String[] tryProtocols = stringArray;
            ArrayList<String> configuredProtocols = new ArrayList<String>(Arrays.asList(tryProtocols));
            List<String> jvmSupportedProtocols = Arrays.asList(sslEngine.getSupportedProtocols());
            ArrayList<String> allowedProtocols = new ArrayList<String>();
            for (String p : TLS_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"}) {
                if (!jvmSupportedProtocols.contains(p) || !configuredProtocols.contains(p)) continue;
                allowedProtocols.add(p);
            }
            sslEngine.setEnabledProtocols(allowedProtocols.toArray(new String[0]));
            XProtocolFactory.performTlsHandshake(sslEngine, channel);
            messageReader.setChannel(new TlsDecryptingByteChannel(channel, sslEngine));
            messageWriter.setChannel(new TlsEncryptingByteChannel(channel, sslEngine));
            messageReader.start();
            return protocol;
        }
        catch (CJCommunicationsException e) {
            throw e;
        }
        catch (IOException | InterruptedException | RuntimeException | ExecutionException ex) {
            throw new CJCommunicationsException(ex);
        }
    }

    private static void performTlsHandshake(SSLEngine sslEngine, AsynchronousSocketChannel channel) throws SSLException {
        sslEngine.beginHandshake();
        SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
        int packetBufferSize = sslEngine.getSession().getPacketBufferSize();
        ByteBuffer myNetData = ByteBuffer.allocate(packetBufferSize);
        ByteBuffer peerNetData = ByteBuffer.allocate(packetBufferSize);
        int appBufferSize = sslEngine.getSession().getApplicationBufferSize();
        ByteBuffer myAppData = ByteBuffer.allocate(appBufferSize);
        ByteBuffer peerAppData = ByteBuffer.allocate(appBufferSize);
        SSLEngineResult res = null;
        while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            block0 : switch (handshakeStatus) {
                case NEED_WRAP: {
                    myNetData.clear();
                    res = sslEngine.wrap(myAppData, myNetData);
                    handshakeStatus = res.getHandshakeStatus();
                    switch (res.getStatus()) {
                        case OK: {
                            myNetData.flip();
                            XProtocolFactory.write(channel, myNetData);
                            break block0;
                        }
                        case BUFFER_OVERFLOW: 
                        case BUFFER_UNDERFLOW: 
                        case CLOSED: {
                            throw new CJCommunicationsException("Unacceptable SSLEngine result: " + res);
                        }
                    }
                    break;
                }
                case NEED_UNWRAP: {
                    peerNetData.flip();
                    res = sslEngine.unwrap(peerNetData, peerAppData);
                    handshakeStatus = res.getHandshakeStatus();
                    switch (res.getStatus()) {
                        case OK: {
                            peerNetData.compact();
                            break block0;
                        }
                        case BUFFER_OVERFLOW: {
                            int newPeerAppDataSize = sslEngine.getSession().getApplicationBufferSize();
                            if (newPeerAppDataSize > peerAppData.capacity()) {
                                ByteBuffer newPeerAppData = ByteBuffer.allocate(newPeerAppDataSize);
                                newPeerAppData.put(peerAppData);
                                newPeerAppData.flip();
                                peerAppData = newPeerAppData;
                                break block0;
                            }
                            peerAppData.compact();
                            break block0;
                        }
                        case BUFFER_UNDERFLOW: {
                            int newPeerNetDataSize = sslEngine.getSession().getPacketBufferSize();
                            if (newPeerNetDataSize > peerNetData.capacity()) {
                                ByteBuffer newPeerNetData = ByteBuffer.allocate(newPeerNetDataSize);
                                newPeerNetData.put(peerNetData);
                                newPeerNetData.flip();
                                peerNetData = newPeerNetData;
                            } else {
                                peerNetData.compact();
                            }
                            if (XProtocolFactory.read(channel, peerNetData) >= 0) break;
                            throw new CJCommunicationsException("Server does not provide enough data to proceed with SSL handshake.");
                        }
                        case CLOSED: {
                            throw new CJCommunicationsException("Unacceptable SSLEngine result: " + res);
                        }
                    }
                    break;
                }
                case NEED_TASK: {
                    sslEngine.getDelegatedTask().run();
                    handshakeStatus = sslEngine.getHandshakeStatus();
                    break;
                }
            }
        }
    }

    private static void write(final AsynchronousSocketChannel channel, final ByteBuffer data) {
        final CompletableFuture f = new CompletableFuture();
        final int bytesToWrite = data.limit();
        CompletionHandler<Integer, Void> handler = new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer bytesWritten, Void nothing) {
                if (bytesWritten < bytesToWrite) {
                    channel.write(data, null, this);
                } else {
                    f.complete(null);
                }
            }

            @Override
            public void failed(Throwable exc, Void nothing) {
                f.completeExceptionally(exc);
            }
        };
        channel.write(data, null, handler);
        try {
            f.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new CJCommunicationsException(ex);
        }
    }

    private static Integer read(AsynchronousSocketChannel channel, ByteBuffer data) {
        Future<Integer> f = channel.read(data);
        try {
            return f.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new CJCommunicationsException(ex);
        }
    }
}

