/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.xdevapi.JsonValue;
import com.mysql.cj.api.xdevapi.Session;
import com.mysql.cj.core.conf.url.ConnectionUrl;
import com.mysql.cj.core.conf.url.HostInfo;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.InvalidConnectionAttributeException;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.JsonString;
import com.mysql.cj.xdevapi.SessionConfig;
import com.mysql.cj.xdevapi.SessionConfigManager;
import com.mysql.cj.xdevapi.SessionImpl;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class SessionFactory {
    public static final String SESSION_NAME = "sessionName";
    private static final Map<String, String> standardKeysMapping = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    private Properties fixStandardKeys(Properties props) {
        Properties sessionProps = new Properties();
        for (String key : props.stringPropertyNames()) {
            String newKey = standardKeysMapping.get(key);
            if (newKey == null) {
                newKey = key;
            }
            sessionProps.setProperty(newKey, props.getProperty(key));
        }
        return sessionProps;
    }

    private ConnectionUrl parseUrl(String url) {
        ConnectionUrl connUrl = ConnectionUrl.getConnectionUrlInstance(url, null);
        if (connUrl.getType() != ConnectionUrl.Type.XDEVAPI_SESSION) {
            throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, "Initialization via URL failed for \"" + url + "\"");
        }
        return connUrl;
    }

    private String jsonToString(JsonValue jsonValue) {
        if (jsonValue instanceof JsonString) {
            return ((JsonString)jsonValue).getString();
        }
        return jsonValue.toString();
    }

    private Session getSession(Properties sessionProperties, Properties complementProperties) {
        Properties sessionProps = this.fixStandardKeys(sessionProperties);
        if (complementProperties != null && !complementProperties.isEmpty()) {
            for (String key : complementProperties.stringPropertyNames()) {
                if (key.equals(SESSION_NAME)) continue;
                String targetKey = standardKeysMapping.get(key);
                if (targetKey == null) {
                    targetKey = key;
                }
                sessionProps.setProperty(targetKey, complementProperties.getProperty(key));
            }
        }
        return new SessionImpl(sessionProps);
    }

    public Session getSession(String url) {
        CJCommunicationsException latestException = null;
        ConnectionUrl connUrl = this.parseUrl(url);
        for (HostInfo hi : connUrl.getHostsList()) {
            try {
                return this.getSession(hi.exposeAsProperties());
            }
            catch (CJCommunicationsException e) {
                latestException = e;
            }
        }
        if (latestException != null) {
            throw latestException;
        }
        return null;
    }

    public Session getSession(Properties properties) {
        if (properties.containsKey(SESSION_NAME)) {
            String sessionName = properties.getProperty(SESSION_NAME);
            SessionConfig sessionConfig = SessionConfigManager.get(sessionName);
            String url = sessionConfig.getUri();
            ConnectionUrl connUrl = this.parseUrl(url);
            return this.getSession(connUrl.getMainHost().exposeAsProperties(), properties);
        }
        return this.getSession(properties, null);
    }

    public Session getSession(Map<String, String> properties) {
        Properties sessionProps = new Properties();
        properties.forEach((k, v) -> sessionProps.setProperty((String)k, v == null ? "null" : v));
        return this.getSession(sessionProps);
    }

    public Session getSession(DbDoc json) {
        Properties sessionProps = new Properties();
        json.forEach((k, v) -> {
            String vStr = this.jsonToString((JsonValue)v);
            sessionProps.setProperty((String)k, vStr == null ? "null" : vStr);
        });
        return this.getSession(sessionProps);
    }

    public Session getSession(SessionConfig sessionConfig) {
        String url = sessionConfig.getUri();
        ConnectionUrl connUrl = this.parseUrl(url);
        return this.getSession(connUrl.getMainHost().exposeAsProperties(), null);
    }

    public Session getSession(SessionConfig sessionConfig, String password) {
        String url = sessionConfig.getUri();
        ConnectionUrl connUrl = this.parseUrl(url);
        Properties overrideProps = new Properties();
        overrideProps.setProperty("password", password != null ? password : "");
        return this.getSession(connUrl.getMainHost().exposeAsProperties(), overrideProps);
    }

    static {
        standardKeysMapping.put("HOST", "HOST");
        standardKeysMapping.put("PORT", "PORT");
        standardKeysMapping.put("DBNAME", "DBNAME");
        standardKeysMapping.put("schema", "DBNAME");
        standardKeysMapping.put("user", "user");
        standardKeysMapping.put("password", "password");
    }
}

