/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.xdevapi.SessionConfigManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SessionConfig {
    private final String name;
    private String uri;
    private Map<String, String> appData = new HashMap<String, String>();

    public SessionConfig(String name, String uri) {
        if (StringUtils.isEmptyOrWhitespaceOnly(name)) {
            ExceptionFactory.createException(WrongArgumentException.class, "Session configuration name cannot be null or empty.");
        }
        this.name = name;
        this.setUri(uri);
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        if (StringUtils.isEmptyOrWhitespaceOnly(uri)) {
            ExceptionFactory.createException(WrongArgumentException.class, "Session configuration URI cannot be null or empty.");
        }
        this.uri = uri;
    }

    public void setAppData(String key, String value) {
        if (StringUtils.isEmptyOrWhitespaceOnly(key)) {
            ExceptionFactory.createException(WrongArgumentException.class, "Application Data key cannot be null or empty.");
        }
        this.appData.put(key, value);
    }

    public void deleteAppData(String key) {
        this.appData.remove(key);
    }

    public String getAppData(String key) {
        return this.appData.get(key);
    }

    public Map<String, String> getAppData() {
        return Collections.unmodifiableMap(this.appData);
    }

    public void save() {
        SessionConfigManager.save(this);
    }
}

