/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.x.core;

import com.mysql.cj.api.ProfilerEventHandler;
import com.mysql.cj.api.Session;
import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.io.Protocol;
import com.mysql.cj.api.io.ServerSession;
import com.mysql.cj.api.io.ValueFactory;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.api.result.Row;
import com.mysql.cj.api.result.RowList;
import com.mysql.cj.api.x.core.ResultCtor;
import com.mysql.cj.api.x.io.MetadataToRowToElement;
import com.mysql.cj.api.x.io.ResultStreamer;
import com.mysql.cj.api.xdevapi.DataStatement;
import com.mysql.cj.api.xdevapi.DatabaseObject;
import com.mysql.cj.api.xdevapi.DocResult;
import com.mysql.cj.api.xdevapi.RowResult;
import com.mysql.cj.api.xdevapi.SqlResult;
import com.mysql.cj.api.xdevapi.ViewDDL;
import com.mysql.cj.core.ServerVersion;
import com.mysql.cj.core.conf.DefaultPropertySet;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.io.LongValueFactory;
import com.mysql.cj.core.io.StringValueFactory;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.x.core.DatabaseObjectDescription;
import com.mysql.cj.x.core.StatementExecuteOk;
import com.mysql.cj.x.core.XDevAPIError;
import com.mysql.cj.x.io.DevapiRowFactory;
import com.mysql.cj.x.io.ResultCreatingResultListener;
import com.mysql.cj.x.io.RowWiseReducingResultListener;
import com.mysql.cj.x.io.StatementExecuteOkBuilder;
import com.mysql.cj.x.io.XProtocol;
import com.mysql.cj.x.io.XProtocolFactory;
import com.mysql.cj.x.io.XProtocolRowInputStream;
import com.mysql.cj.xdevapi.CreateIndexParams;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.DbDocValueFactory;
import com.mysql.cj.xdevapi.DocResultImpl;
import com.mysql.cj.xdevapi.ExprUnparser;
import com.mysql.cj.xdevapi.FilterParams;
import com.mysql.cj.xdevapi.FindParams;
import com.mysql.cj.xdevapi.InsertParams;
import com.mysql.cj.xdevapi.RowResultImpl;
import com.mysql.cj.xdevapi.SqlDataResult;
import com.mysql.cj.xdevapi.SqlResultImpl;
import com.mysql.cj.xdevapi.SqlUpdateResult;
import com.mysql.cj.xdevapi.UpdateParams;
import com.mysql.cj.xdevapi.UpdateSpec;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Spliterators;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class MysqlxSession
implements Session {
    private XProtocol protocol;
    private ResultStreamer currentResult;
    private String host;
    private int port;
    private TimeZone defaultTimeZone = TimeZone.getDefault();
    ValueFactory<String> svf = new StringValueFactory();
    protected String authMech = "MYSQL41";

    public MysqlxSession(Properties properties) {
        DefaultPropertySet pset = new DefaultPropertySet();
        pset.initializeProperties(properties);
        this.host = properties.getProperty("HOST");
        if (this.host == null || StringUtils.isEmptyOrWhitespaceOnly(this.host)) {
            this.host = "localhost";
        }
        this.port = Integer.parseInt(properties.getProperty("PORT", "33060"));
        this.protocol = XProtocolFactory.getInstance(this.host, this.port, pset);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public PropertySet getPropertySet() {
        return this.protocol.getPropertySet();
    }

    public Protocol getProtocol() {
        throw new NullPointerException("TODO: You are not allowed to have my protocol");
    }

    @Override
    public void changeUser(String user, String password, String database) {
        this.authMech = this.protocol.getPropertySet().getStringReadableProperty("xdevapi.auth").getValue();
        boolean overTLS = this.protocol.getTls();
        this.authMech = this.authMech == null ? (overTLS ? "PLAIN" : "MYSQL41") : this.authMech.toUpperCase();
        switch (this.authMech) {
            case "MYSQL41": {
                this.protocol.sendSaslMysql41AuthStart();
                byte[] salt = this.protocol.readAuthenticateContinue();
                this.protocol.sendSaslMysql41AuthContinue(user, password, salt, database);
                break;
            }
            case "PLAIN": {
                if (overTLS) {
                    this.protocol.sendSaslPlainAuthStart(user, password, database);
                    break;
                }
                throw new XDevAPIError("PLAIN authentication is not allowed via unencrypted connection.");
            }
            case "EXTERNAL": {
                this.protocol.sendSaslExternalAuthStart(database);
                break;
            }
            default: {
                throw new WrongArgumentException("Unknown authentication mechanism '" + this.authMech + "'.");
            }
        }
        this.protocol.readAuthenticateOk();
        this.setupInternalState();
    }

    private void setupInternalState() {
        this.protocol.setMaxAllowedPacket((int)this.queryForLong("select @@mysqlx_max_allowed_packet"));
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        throw new NullPointerException("TODO: You are not allowed to have this");
    }

    @Override
    public void setExceptionInterceptor(ExceptionInterceptor exceptionInterceptor) {
        throw new NullPointerException("TODO: I don't need your stinkin exception interceptor");
    }

    @Override
    public boolean inTransactionOnServer() {
        throw new NullPointerException("TODO: who wants to know? Also, check NEW tx state in OK packet extensions");
    }

    @Override
    public String getServerVariable(String name) {
        throw new NullPointerException("TODO: ");
    }

    @Override
    public Map<String, String> getServerVariables() {
        throw new NullPointerException("TODO: ");
    }

    @Override
    public void abortInternal() {
        throw new NullPointerException("TODO: REPLACE ME WITH close() unless there's different semantics here");
    }

    @Override
    public void quit() {
        throw new NullPointerException("TODO: REPLACE ME WITH close() unless there's different semantics here");
    }

    @Override
    public void forceClose() {
        throw new NullPointerException("TODO: REPLACE ME WITH close() unless there's different semantics here");
    }

    @Override
    public ServerVersion getServerVersion() {
        throw new NullPointerException("TODO: isn't this in server session?");
    }

    @Override
    public boolean versionMeetsMinimum(int major, int minor, int subminor) {
        throw new NullPointerException("TODO: ");
    }

    @Override
    public long getThreadId() {
        return this.protocol.getClientId();
    }

    @Override
    public boolean isSetNeededForAutoCommitMode(boolean autoCommitFlag) {
        throw new NullPointerException("TODO: ");
    }

    private void newCommand() {
        if (this.currentResult != null) {
            try {
                this.currentResult.finishStreaming();
            }
            finally {
                this.currentResult = null;
            }
        }
    }

    public StatementExecuteOk addDocs(String schemaName, String collectionName, List<String> jsonStrings) {
        this.newCommand();
        this.protocol.sendDocInsert(schemaName, collectionName, jsonStrings);
        return this.protocol.readStatementExecuteOk();
    }

    public StatementExecuteOk insertRows(String schemaName, String tableName, InsertParams insertParams) {
        this.newCommand();
        this.protocol.sendRowInsert(schemaName, tableName, insertParams);
        return this.protocol.readStatementExecuteOk();
    }

    public StatementExecuteOk updateDocs(FilterParams filterParams, List<UpdateSpec> updates) {
        this.newCommand();
        this.protocol.sendDocUpdates(filterParams, updates);
        return this.protocol.readStatementExecuteOk();
    }

    public StatementExecuteOk updateRows(FilterParams filterParams, UpdateParams updateParams) {
        this.newCommand();
        this.protocol.sendRowUpdates(filterParams, updateParams);
        return this.protocol.readStatementExecuteOk();
    }

    public StatementExecuteOk deleteDocs(FilterParams filterParams) {
        this.newCommand();
        this.protocol.sendDocDelete(filterParams);
        return this.protocol.readStatementExecuteOk();
    }

    public StatementExecuteOk deleteRows(FilterParams filterParams) {
        this.newCommand();
        this.protocol.sendDocDelete(filterParams);
        return this.protocol.readStatementExecuteOk();
    }

    private <T extends ResultStreamer> T findInternal(FindParams findParams, ResultCtor<T> resultCtor) {
        ResultStreamer res;
        this.newCommand();
        this.protocol.sendFind(findParams);
        ArrayList<Field> metadata = this.protocol.readMetadata("latin1");
        this.currentResult = res = (ResultStreamer)((BiFunction)resultCtor.apply(metadata)).apply(this.protocol.getRowInputStream(metadata), this.protocol::readStatementExecuteOk);
        return (T)res;
    }

    public DocResultImpl findDocs(FindParams findParams) {
        return (DocResultImpl)this.findInternal(findParams, metadata -> (rows, task) -> new DocResultImpl((RowList)rows, (Supplier<StatementExecuteOk>)task));
    }

    public RowResultImpl selectRows(FindParams findParams) {
        return (RowResultImpl)this.findInternal(findParams, metadata -> (rows, task) -> new RowResultImpl((ArrayList<Field>)metadata, this.defaultTimeZone, (RowList)rows, (Supplier<StatementExecuteOk>)task));
    }

    public void createCollection(String schemaName, String collectionName) {
        this.newCommand();
        this.protocol.sendCreateCollection(schemaName, collectionName);
        this.protocol.readStatementExecuteOk();
    }

    public void dropCollection(String schemaName, String collectionName) {
        this.newCommand();
        this.protocol.sendDropCollection(schemaName, collectionName);
        this.protocol.readStatementExecuteOk();
    }

    public void dropCollectionIfExists(String schemaName, String collectionName) {
        if (this.tableExists(schemaName, collectionName)) {
            this.dropCollection(schemaName, collectionName);
        }
    }

    public StatementExecuteOk createCollectionIndex(String schemaName, String collectionName, CreateIndexParams params) {
        this.newCommand();
        this.protocol.sendCreateCollectionIndex(schemaName, collectionName, params);
        return this.protocol.readStatementExecuteOk();
    }

    public StatementExecuteOk dropCollectionIndex(String schemaName, String collectionName, String indexName) {
        this.newCommand();
        this.protocol.sendDropCollectionIndex(schemaName, collectionName, indexName);
        return this.protocol.readStatementExecuteOk();
    }

    private long queryForLong(String sql) {
        this.newCommand();
        this.protocol.sendSqlStatement(sql);
        ArrayList<Field> metadata = this.protocol.readMetadata("latin1");
        long count = this.protocol.getRowInputStream(metadata).next().getValue(0, new LongValueFactory());
        this.protocol.readStatementExecuteOk();
        return count;
    }

    public long tableCount(String schemaName, String tableName) {
        StringBuilder stmt = new StringBuilder("select count(*) from ");
        stmt.append(ExprUnparser.quoteIdentifier(schemaName));
        stmt.append(".");
        stmt.append(ExprUnparser.quoteIdentifier(tableName));
        return this.queryForLong(stmt.toString());
    }

    public boolean schemaExists(String schemaName) {
        StringBuilder stmt = new StringBuilder("select count(*) from information_schema.schemata where schema_name = '");
        stmt.append(schemaName.replaceAll("'", "\\'"));
        stmt.append("'");
        return 1L == this.queryForLong(stmt.toString());
    }

    public boolean tableExists(String schemaName, String tableName) {
        StringBuilder stmt = new StringBuilder("select count(*) from information_schema.tables where table_schema = '");
        stmt.append(schemaName.replaceAll("'", "\\'"));
        stmt.append("' and table_name = '");
        stmt.append(tableName.replaceAll("'", "\\'"));
        stmt.append("'");
        return 1L == this.queryForLong(stmt.toString());
    }

    public void createView(String schemaName, String collectionName, boolean replaceExisting, List<String> columns, ViewDDL.ViewAlgorithm algorithm, ViewDDL.ViewSqlSecurity security, String definer, FindParams findParams, ViewDDL.ViewCheckOption checkOpt) {
        this.newCommand();
        this.protocol.sendCreateView(schemaName, collectionName, replaceExisting, columns, algorithm, security, definer, findParams, checkOpt);
        this.protocol.readOk();
    }

    public void modifyView(String schemaName, String collectionName, List<String> columns, ViewDDL.ViewAlgorithm algorithm, ViewDDL.ViewSqlSecurity security, String definer, FindParams findParams, ViewDDL.ViewCheckOption checkOpt) {
        this.newCommand();
        this.protocol.sendModifyView(schemaName, collectionName, columns, algorithm, security, definer, findParams, checkOpt);
        this.protocol.readOk();
    }

    public void dropView(String schemaName, String collectionName, boolean ifExists) {
        this.newCommand();
        this.protocol.sendDropView(schemaName, collectionName, ifExists);
        this.protocol.readOk();
    }

    public List<String> getObjectNamesOfType(String schemaName, DatabaseObject.DbObjectType ... type) {
        return this.getObjectNamesOfType(schemaName, (String)null, type);
    }

    public List<String> getObjectNamesOfType(String schemaName, String pattern, DatabaseObject.DbObjectType ... type) {
        this.newCommand();
        if (pattern == null) {
            this.protocol.sendListObjects(schemaName);
        } else {
            this.protocol.sendListObjects(schemaName, pattern);
        }
        ArrayList<Field> metadata = this.protocol.readMetadata("latin1");
        XProtocolRowInputStream ris = this.protocol.getRowInputStream(metadata);
        Set strTypes = Arrays.stream(type).map(Enum::toString).collect(Collectors.toSet());
        List<String> objectNames = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ris, 0), false).filter(r -> strTypes.contains(r.getValue(1, this.svf))).map(r -> r.getValue(0, this.svf)).collect(Collectors.toList());
        this.protocol.readStatementExecuteOk();
        return objectNames;
    }

    public List<DatabaseObjectDescription> listObjects(String schemaName, String pattern) {
        this.newCommand();
        if (pattern == null) {
            this.protocol.sendListObjects(schemaName);
        } else {
            this.protocol.sendListObjects(schemaName, pattern);
        }
        ArrayList<Field> metadata = this.protocol.readMetadata("latin1");
        XProtocolRowInputStream ris = this.protocol.getRowInputStream(metadata);
        List<DatabaseObjectDescription> objects = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ris, 0), false).map(r -> new DatabaseObjectDescription(r.getValue(0, this.svf), r.getValue(1, this.svf))).collect(Collectors.toList());
        this.protocol.readStatementExecuteOk();
        return objects;
    }

    public <RES_T, R> RES_T query(String sql, Function<Row, R> eachRow, Collector<R, ?, RES_T> collector) {
        this.newCommand();
        this.protocol.sendSqlStatement(sql);
        ArrayList<Field> metadata = this.protocol.readMetadata("latin1");
        XProtocolRowInputStream ris = this.protocol.getRowInputStream(metadata);
        RES_T result = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ris, 0), false).map(eachRow).collect(collector);
        this.protocol.readStatementExecuteOk();
        return result;
    }

    public SqlResult executeSql(String sql, Object args) {
        this.newCommand();
        this.protocol.sendSqlStatement(sql, args);
        boolean[] readLastResult = new boolean[1];
        Supplier<StatementExecuteOk> okReader = () -> {
            if (readLastResult[0]) {
                throw new CJCommunicationsException("Invalid state attempting to read ok packet");
            }
            if (this.protocol.hasMoreResults()) {
                return new StatementExecuteOkBuilder().build();
            }
            readLastResult[0] = true;
            return this.protocol.readStatementExecuteOk();
        };
        Supplier<SqlResult> resultStream = () -> {
            if (readLastResult[0]) {
                return null;
            }
            if (this.protocol.isSqlResultPending()) {
                ArrayList<Field> metadata = this.protocol.readMetadata("latin1");
                return new SqlDataResult(metadata, this.defaultTimeZone, this.protocol.getRowInputStream(metadata), okReader);
            }
            readLastResult[0] = true;
            return new SqlUpdateResult(this.protocol.readStatementExecuteOk());
        };
        SqlResultImpl res = new SqlResultImpl(resultStream);
        this.currentResult = res;
        return res;
    }

    public CompletableFuture<SqlResult> asyncExecuteSql(String sql, Object args) {
        this.newCommand();
        return this.protocol.asyncExecuteSql(sql, args, "latin1", this.defaultTimeZone);
    }

    public StatementExecuteOk update(String sql) {
        this.newCommand();
        this.protocol.sendSqlStatement(sql);
        return this.protocol.readStatementExecuteOk();
    }

    public boolean isOpen() {
        return this.protocol.isOpen();
    }

    public void close() {
        try {
            this.newCommand();
            this.protocol.sendSessionClose();
            this.protocol.readOk();
        }
        finally {
            try {
                this.protocol.close();
            }
            catch (IOException ex) {
                throw new CJCommunicationsException(ex);
            }
        }
    }

    private <RES_T> CompletableFuture<RES_T> asyncFindInternal(FindParams findParams, ResultCtor<? extends RES_T> resultCtor) {
        CompletableFuture f = new CompletableFuture();
        ResultCreatingResultListener<? extends RES_T> l = new ResultCreatingResultListener<RES_T>(resultCtor, f);
        this.newCommand();
        this.protocol.asyncFind(findParams, "latin1", l, f);
        return f;
    }

    public CompletableFuture<DocResult> asyncFindDocs(FindParams findParams) {
        return this.asyncFindInternal(findParams, metadata -> (rows, task) -> new DocResultImpl((RowList)rows, (Supplier<StatementExecuteOk>)task));
    }

    public CompletableFuture<RowResult> asyncSelectRows(FindParams findParams) {
        return this.asyncFindInternal(findParams, metadata -> (rows, task) -> new RowResultImpl((ArrayList<Field>)metadata, this.defaultTimeZone, (RowList)rows, (Supplier<StatementExecuteOk>)task));
    }

    public <R> CompletableFuture<R> asyncFindDocsReduce(FindParams findParams, R id, DataStatement.Reducer<DbDoc, R> reducer) {
        CompletableFuture f = new CompletableFuture();
        RowWiseReducingResultListener<DbDoc, R> l = new RowWiseReducingResultListener<DbDoc, R>(id, reducer, f, _ignored_metadata -> r -> r.getValue(0, new DbDocValueFactory()));
        this.newCommand();
        this.protocol.asyncFind(findParams, "latin1", l, f);
        return f;
    }

    public <R> CompletableFuture<R> asyncSelectRowsReduce(FindParams findParams, R id, DataStatement.Reducer<com.mysql.cj.api.xdevapi.Row, R> reducer) {
        CompletableFuture f = new CompletableFuture();
        MetadataToRowToElement rowFactory = metadata -> new DevapiRowFactory((ArrayList<Field>)metadata, this.defaultTimeZone);
        RowWiseReducingResultListener<com.mysql.cj.api.xdevapi.Row, R> l = new RowWiseReducingResultListener<com.mysql.cj.api.xdevapi.Row, R>(id, reducer, f, rowFactory);
        this.newCommand();
        this.protocol.asyncFind(findParams, "latin1", l, f);
        return f;
    }

    public CompletableFuture<StatementExecuteOk> asyncAddDocs(String schemaName, String collectionName, List<String> jsonStrings) {
        this.newCommand();
        return this.protocol.asyncAddDocs(schemaName, collectionName, jsonStrings);
    }

    public CompletableFuture<StatementExecuteOk> asyncInsertRows(String schemaName, String tableName, InsertParams insertParams) {
        this.newCommand();
        return this.protocol.asyncInsertRows(schemaName, tableName, insertParams);
    }

    public CompletableFuture<StatementExecuteOk> asyncUpdateDocs(FilterParams filterParams, List<UpdateSpec> updates) {
        this.newCommand();
        return this.protocol.asyncUpdateDocs(filterParams, updates);
    }

    public CompletableFuture<StatementExecuteOk> asyncUpdateRows(FilterParams filterParams, UpdateParams updateParams) {
        this.newCommand();
        return this.protocol.asyncUpdateRows(filterParams, updateParams);
    }

    public CompletableFuture<StatementExecuteOk> asyncDeleteDocs(FilterParams filterParams) {
        this.newCommand();
        return this.protocol.asyncDeleteDocs(filterParams);
    }

    public CompletableFuture<StatementExecuteOk> asyncDeleteRows(FilterParams filterParams) {
        this.newCommand();
        return this.protocol.asyncDeleteDocs(filterParams);
    }

    public CompletableFuture<StatementExecuteOk> asyncCreateCollectionIndex(String schemaName, String collectionName, CreateIndexParams params) {
        this.newCommand();
        return this.protocol.asyncCreateCollectionIndex(schemaName, collectionName, params);
    }

    public CompletableFuture<StatementExecuteOk> asyncDropCollectionIndex(String schemaName, String collectionName, String indexName) {
        this.newCommand();
        return this.protocol.asyncDropCollectionIndex(schemaName, collectionName, indexName);
    }

    @Override
    public int getServerVariable(String variableName, int fallbackValue) {
        return 0;
    }

    @Override
    public Log getLog() {
        return null;
    }

    @Override
    public void setLog(Log log) {
    }

    @Override
    public void configureTimezone() {
    }

    @Override
    public TimeZone getDefaultTimeZone() {
        return null;
    }

    @Override
    public String getErrorMessageEncoding() {
        return null;
    }

    @Override
    public int getMaxBytesPerChar(String javaCharsetName) {
        return 0;
    }

    @Override
    public int getMaxBytesPerChar(Integer charsetIndex, String javaCharsetName) {
        return 0;
    }

    @Override
    public String getEncodingForIndex(int collationIndex) {
        return null;
    }

    @Override
    public ProfilerEventHandler getProfilerEventHandler() {
        return null;
    }

    @Override
    public void setProfilerEventHandler(ProfilerEventHandler h) {
    }

    @Override
    public ServerSession getServerSession() {
        return null;
    }

    @Override
    public boolean isSSLEstablished() {
        return false;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return null;
    }

    @Override
    public boolean serverSupportsFracSecs() {
        return true;
    }

    @Override
    public String getProcessHost() {
        return null;
    }

    @Override
    public void addListener(Session.SessionEventListener l) {
    }

    @Override
    public void removeListener(Session.SessionEventListener l) {
    }
}

