/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.ha;

import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.jdbc.ConnectionImpl;
import com.mysql.cj.jdbc.ha.LoadBalancedConnectionProxy;
import com.mysql.cj.jdbc.ha.RandomBalanceStrategy;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class ServerAffinityStrategy
extends RandomBalanceStrategy {
    public String[] affinityOrderedServers = null;

    public ServerAffinityStrategy(String affinityOrdervers) {
        if (!StringUtils.isNullOrEmpty(affinityOrdervers)) {
            this.affinityOrderedServers = affinityOrdervers.split(",");
        }
    }

    @Override
    public ConnectionImpl pickConnection(LoadBalancedConnectionProxy proxy, List<String> configuredHosts, Map<String, ConnectionImpl> liveConnections, long[] responseTimes, int numRetries) throws SQLException {
        if (this.affinityOrderedServers == null) {
            return super.pickConnection(proxy, configuredHosts, liveConnections, responseTimes, numRetries);
        }
        Map<String, Long> blackList = proxy.getGlobalBlacklist();
        for (String host : this.affinityOrderedServers) {
            if (!configuredHosts.contains(host) || blackList.containsKey(host)) continue;
            ConnectionImpl conn = liveConnections.get(host);
            if (conn != null) {
                return conn;
            }
            try {
                conn = proxy.createConnectionForHost(host);
                return conn;
            }
            catch (SQLException sqlEx) {
                if (!proxy.shouldExceptionTriggerConnectionSwitch(sqlEx)) continue;
                proxy.addToGlobalBlacklist(host);
            }
        }
        return super.pickConnection(proxy, configuredHosts, liveConnections, responseTimes, numRetries);
    }
}

