/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.xdevapi.DataStatement;
import com.mysql.cj.api.xdevapi.Row;
import com.mysql.cj.api.xdevapi.RowResult;
import com.mysql.cj.api.xdevapi.SelectStatement;
import com.mysql.cj.x.core.MysqlxSession;
import com.mysql.cj.xdevapi.FilterableStatement;
import com.mysql.cj.xdevapi.FindParams;
import com.mysql.cj.xdevapi.RowResultImpl;
import com.mysql.cj.xdevapi.TableFindParams;
import java.util.concurrent.CompletableFuture;

public class SelectStatementImpl
extends FilterableStatement<SelectStatement, RowResult>
implements SelectStatement {
    private MysqlxSession mysqlxSession;
    private FindParams findParams;

    SelectStatementImpl(MysqlxSession mysqlxSession, String schema, String table, String projection) {
        super(new TableFindParams(schema, table));
        this.findParams = (TableFindParams)this.filterParams;
        this.mysqlxSession = mysqlxSession;
        if (projection != null && projection.length() > 0) {
            this.findParams.setFields(projection);
        }
    }

    SelectStatementImpl(MysqlxSession mysqlxSession, String schema, String table, String ... projection) {
        super(new TableFindParams(schema, table));
        this.findParams = (TableFindParams)this.filterParams;
        this.mysqlxSession = mysqlxSession;
        if (projection != null && projection.length > 0) {
            this.findParams.setFields(projection);
        }
    }

    @Override
    public RowResultImpl execute() {
        return this.mysqlxSession.selectRows(this.findParams);
    }

    @Override
    public CompletableFuture<RowResult> executeAsync() {
        return this.mysqlxSession.asyncSelectRows(this.findParams);
    }

    @Override
    public <R> CompletableFuture<R> executeAsync(R id, DataStatement.Reducer<Row, R> reducer) {
        return this.mysqlxSession.asyncSelectRowsReduce(this.findParams, id, reducer);
    }

    @Override
    public SelectStatement groupBy(String ... groupBy) {
        this.findParams.setGrouping(groupBy);
        return this;
    }

    @Override
    public SelectStatement having(String having) {
        this.findParams.setGroupingCriteria(having);
        return this;
    }

    @Override
    public FindParams getFindParams() {
        return this.findParams;
    }
}

