/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.xdevapi.CreateCollectionIndexStatement;
import com.mysql.cj.api.xdevapi.Result;
import com.mysql.cj.x.core.MysqlxSession;
import com.mysql.cj.x.core.StatementExecuteOk;
import com.mysql.cj.xdevapi.CreateIndexParams;
import com.mysql.cj.xdevapi.UpdateResult;
import java.util.concurrent.CompletableFuture;

public class CreateCollectionIndexStatementImpl
implements CreateCollectionIndexStatement {
    private MysqlxSession mysqlxSession;
    private String schemaName;
    private String collectionName;
    private CreateIndexParams createIndexParams;

    CreateCollectionIndexStatementImpl(MysqlxSession mysqlxSession, String schema, String collection, String indexName, boolean unique) {
        this.mysqlxSession = mysqlxSession;
        this.schemaName = schema;
        this.collectionName = collection;
        this.createIndexParams = new CreateIndexParams(indexName, unique);
    }

    @Override
    public CreateCollectionIndexStatement field(String docPath, String type, boolean notNull) {
        this.createIndexParams.addField(docPath, type, notNull);
        return this;
    }

    @Override
    public Result execute() {
        StatementExecuteOk ok = this.mysqlxSession.createCollectionIndex(this.schemaName, this.collectionName, this.createIndexParams);
        return new UpdateResult(ok);
    }

    @Override
    public CompletableFuture<Result> executeAsync() {
        CompletableFuture<StatementExecuteOk> okF = this.mysqlxSession.asyncCreateCollectionIndex(this.schemaName, this.collectionName, this.createIndexParams);
        return okF.thenApply(ok -> new UpdateResult((StatementExecuteOk)ok));
    }
}

