/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.result;

import com.mysql.cj.api.mysqla.io.NativeProtocol;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.api.mysqla.result.ResultsetRows;
import com.mysql.cj.api.result.Row;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.mysqla.io.MysqlaProtocol;
import com.mysql.cj.mysqla.result.AbstractResultsetRows;
import java.util.ArrayList;
import java.util.List;

public class ResultsetRowsCursor
extends AbstractResultsetRows
implements ResultsetRows {
    private List<Row> fetchedRows;
    private int currentPositionInEntireResult = -1;
    private boolean lastRowFetched = false;
    private MysqlaProtocol protocol;
    private boolean firstFetchCompleted = false;

    public ResultsetRowsCursor(MysqlaProtocol ioChannel, Field[] metadata) {
        this.metadata = metadata;
        this.protocol = ioChannel;
    }

    @Override
    public boolean isAfterLast() {
        return this.lastRowFetched && this.currentPositionInFetchedRows > this.fetchedRows.size();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.currentPositionInEntireResult < 0;
    }

    @Override
    public int getPosition() {
        return this.currentPositionInEntireResult + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.isBeforeFirst() && this.isAfterLast();
    }

    @Override
    public boolean isFirst() {
        return this.currentPositionInEntireResult == 0;
    }

    @Override
    public boolean isLast() {
        return this.lastRowFetched && this.currentPositionInFetchedRows == this.fetchedRows.size() - 1;
    }

    @Override
    public void close() {
        this.metadata = null;
        this.owner = null;
    }

    @Override
    public boolean hasNext() {
        int maxRows;
        if (this.fetchedRows != null && this.fetchedRows.size() == 0) {
            return false;
        }
        if (this.owner != null && (maxRows = this.owner.getOwningStatementMaxRows()) != -1 && this.currentPositionInEntireResult + 1 > maxRows) {
            return false;
        }
        if (this.currentPositionInEntireResult != -1) {
            if (this.currentPositionInFetchedRows < this.fetchedRows.size() - 1) {
                return true;
            }
            if (this.currentPositionInFetchedRows == this.fetchedRows.size() && this.lastRowFetched) {
                return false;
            }
            this.fetchMoreRows();
            return this.fetchedRows.size() > 0;
        }
        this.fetchMoreRows();
        return this.fetchedRows.size() > 0;
    }

    @Override
    public Row next() {
        if (this.fetchedRows == null && this.currentPositionInEntireResult != -1) {
            throw ExceptionFactory.createException(Messages.getString("ResultSet.Operation_not_allowed_after_ResultSet_closed_144"), this.protocol.getExceptionInterceptor());
        }
        if (!this.hasNext()) {
            return null;
        }
        ++this.currentPositionInEntireResult;
        ++this.currentPositionInFetchedRows;
        if (this.fetchedRows != null && this.fetchedRows.size() == 0) {
            return null;
        }
        if (this.fetchedRows == null || this.currentPositionInFetchedRows > this.fetchedRows.size() - 1) {
            this.fetchMoreRows();
            this.currentPositionInFetchedRows = 0;
        }
        Row row = this.fetchedRows.get(this.currentPositionInFetchedRows);
        row.setMetadata(this.metadata);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchMoreRows() {
        if (this.lastRowFetched) {
            this.fetchedRows = new ArrayList<Row>(0);
            return;
        }
        Object object = this.owner.getConnection().getConnectionMutex();
        synchronized (object) {
            try {
                int numRowsToFetch;
                boolean oldFirstFetchCompleted = this.firstFetchCompleted;
                if (!this.firstFetchCompleted) {
                    this.firstFetchCompleted = true;
                }
                if ((numRowsToFetch = this.owner.getOwnerFetchSize()) == 0) {
                    numRowsToFetch = this.owner.getOwningStatementFetchSize();
                }
                if (numRowsToFetch == Integer.MIN_VALUE) {
                    numRowsToFetch = 1;
                }
                if (this.fetchedRows == null) {
                    this.fetchedRows = new ArrayList<Row>(numRowsToFetch);
                } else {
                    this.fetchedRows.clear();
                }
                PacketPayload sharedSendPacket = this.protocol.getSharedSendPacket();
                sharedSendPacket.setPosition(0);
                sharedSendPacket.writeInteger(NativeProtocol.IntegerDataType.INT1, 28L);
                sharedSendPacket.writeInteger(NativeProtocol.IntegerDataType.INT4, this.owner.getOwningStatementServerId());
                sharedSendPacket.writeInteger(NativeProtocol.IntegerDataType.INT4, numRowsToFetch);
                this.protocol.sendCommand(28, null, sharedSendPacket, true, null, 0);
                Row row = null;
                while ((row = this.protocol.getResultsHandler().nextRow(this.metadata, this.metadata.length, true, 1007, false)) != null) {
                    this.fetchedRows.add(row);
                }
                this.currentPositionInFetchedRows = -1;
                if (this.protocol.getServerSession().isLastRowSent()) {
                    this.lastRowFetched = true;
                    if (!oldFirstFetchCompleted && this.fetchedRows.size() == 0) {
                        this.wasEmpty = true;
                    }
                }
            }
            catch (Exception ex) {
                throw ExceptionFactory.createException(ex.getMessage(), ex);
            }
        }
    }
}

