/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.rmi.jrmp;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import mx4j.adaptor.rmi.RMIAdaptor;
import mx4j.adaptor.rmi.RMIProtocolAdaptorImpl;
import mx4j.adaptor.rmi.SSLAdaptorRMIServerSocketFactory;
import mx4j.adaptor.rmi.SSLRMIClientSocketFactory;
import mx4j.adaptor.rmi.jrmp.JRMPAdaptorMBean;

public class JRMPAdaptor
extends RMIAdaptor
implements JRMPAdaptorMBean {
    private RMIProtocolAdaptorImpl m_adaptor;
    private boolean m_running;
    private int m_port;
    private String m_sslFactory;

    public void start() throws RemoteException, NamingException, JMException {
        if (!this.isRunning()) {
            this.m_adaptor = new RMIProtocolAdaptorImpl(this.getMBeanServer(), this.getObjectName(), this.getInterceptors());
            if (this.isSSL()) {
                ObjectName factory = new ObjectName(this.getSSLFactory());
                UnicastRemoteObject.exportObject(this.m_adaptor, this.getPort(), new SSLRMIClientSocketFactory(), new SSLAdaptorRMIServerSocketFactory(this.getMBeanServer(), factory));
            } else {
                UnicastRemoteObject.exportObject((Remote)this.m_adaptor, this.getPort());
            }
            String jndiName = this.findJNDIName();
            this.setJNDIName(jndiName);
            this.bind(this.m_adaptor);
            this.m_running = true;
        }
    }

    public void stop() throws NoSuchObjectException, NamingException {
        if (this.isRunning()) {
            UnicastRemoteObject.unexportObject(this.m_adaptor, true);
            this.unbind();
            this.m_adaptor.unregisterInterceptors();
            this.m_running = false;
        }
    }

    public boolean isRunning() {
        return this.m_running;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot perform this operation while running");
        }
        this.m_port = port;
    }

    public String getSSLFactory() {
        return this.m_sslFactory;
    }

    public void setSSLFactory(String factory) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot perform this operation while running");
        }
        this.m_sslFactory = factory;
    }

    private boolean isSSL() {
        return this.getSSLFactory() != null;
    }

    protected ObjectName getDefaultObjectName() throws MalformedObjectNameException {
        return new ObjectName("Adaptor:protocol=JRMP");
    }

    private String findJNDIName() {
        String jndi = this.getJNDIName();
        if (jndi == null || jndi.trim().length() == 0) {
            StringBuffer buffer = new StringBuffer("jmx-adaptor:jrmp:");
            buffer.append(this.getHostName()).append(":");
            buffer.append(this.getPort());
            return buffer.toString();
        }
        return jndi;
    }
}

