/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.RuntimeMBeanException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import mx4j.adaptor.http.HttpException;
import mx4j.adaptor.http.HttpInputStream;
import mx4j.adaptor.http.HttpOutputStream;
import mx4j.adaptor.http.ProcessorMBean;
import mx4j.adaptor.http.XSLTProcessorMBean;
import mx4j.log.Log;
import mx4j.log.Logger;
import org.w3c.dom.Document;

public class XSLTProcessor
implements ProcessorMBean,
XSLTProcessorMBean,
URIResolver {
    TransformerFactory factory = null;
    private Map templatesCache = new HashMap();
    private static final String ENCODING = "UTF-8";
    private String path = "mx4j/adaptor/http/xsl";
    private File root = null;
    private Map mimeTypes = new HashMap();
    private Logger log = null;
    private boolean useJar = true;
    private boolean useCache = true;
    private ClassLoader targetClassLoader = ClassLoader.getSystemClassLoader();

    public XSLTProcessor() {
        this.factory = TransformerFactory.newInstance();
        this.factory.setURIResolver(this);
        this.mimeTypes.put(".gif", "image/gif");
        this.mimeTypes.put(".jpg", "image/jpg");
        this.mimeTypes.put(".png", "image/png");
        this.mimeTypes.put(".html", "text/html");
        this.mimeTypes.put(".htm", "text/html");
        this.mimeTypes.put(".css", "text/css");
        this.log = Log.getLogger("XSLTProcessor");
    }

    public void writeResponse(HttpOutputStream out, HttpInputStream in, Document document) throws IOException {
        out.setCode(200);
        out.setHeader("Content-Type", "text/html");
        out.sendHeaders();
        Transformer transformer = null;
        String path = this.preProcess(in.getPath());
        transformer = in.getVariable("template") != null ? this.createTransformer(in.getVariable("template") + ".xsl") : this.createTransformer(path + ".xsl");
        if (transformer != null) {
            Map variables = in.getVariables();
            Iterator j = variables.keySet().iterator();
            while (j.hasNext()) {
                String key = (String)j.next();
                String value = (String)variables.get(key);
                transformer.setParameter("request." + key, value);
            }
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                this.log.trace("transforming " + path);
                transformer.transform(new DOMSource(document), new StreamResult(output));
                output.writeTo(out);
            }
            catch (TransformerException e) {
                this.log.error("Transformation exception ", e);
            }
        } else {
            this.log.warn("Transformer for path " + path + " not found");
        }
    }

    protected Transformer createTransformer(String path) {
        Transformer transformer = null;
        try {
            if (this.useCache && this.templatesCache.containsKey(path)) {
                transformer = ((Templates)this.templatesCache.get(path)).newTransformer();
            } else {
                InputStream file = this.getInputStream(path);
                if (file != null) {
                    this.log.info("Creating template for path " + path);
                    Templates template = this.factory.newTemplates(new StreamSource(file));
                    transformer = template.newTransformer();
                    if (this.useCache) {
                        this.templatesCache.put(path, template);
                    }
                } else {
                    this.log.warn("template for path " + path + " not found");
                }
            }
        }
        catch (TransformerConfigurationException e) {
            this.log.error("Exception during template construction", e);
        }
        return transformer;
    }

    public void writeError(HttpOutputStream out, HttpInputStream in, Exception e) throws IOException {
        Exception t = e;
        if (e instanceof RuntimeMBeanException) {
            t = ((RuntimeMBeanException)e).getTargetException();
        }
        this.log.info("Processing error " + t.getMessage());
        if (t instanceof HttpException) {
            out.setCode(((HttpException)e).getCode());
            out.setHeader("Content-Type", "text/html");
            out.sendHeaders();
            Transformer transformer = this.createTransformer("error.xsl");
            Document doc = ((HttpException)e).getResponseDoc();
            if (doc != null) {
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    transformer.transform(new DOMSource(doc), new StreamResult(output));
                    output.writeTo(out);
                }
                catch (TransformerException ex) {
                    this.log.error("Exception during error output", ex);
                }
            }
        } else {
            out.setCode(500);
            out.setHeader("Content-Type", "text/html");
            out.sendHeaders();
        }
    }

    public String preProcess(String path) {
        if (path.equals("/")) {
            path = "/serverbydomain";
        }
        return path;
    }

    public String notFoundElement(String path, HttpOutputStream out, HttpInputStream in) throws IOException, HttpException {
        File file = new File(this.path, path);
        this.log.info("Processing file request " + file);
        boolean found = false;
        String name = file.getName();
        int extensionIndex = name.lastIndexOf(46);
        String mime = null;
        if (extensionIndex < 0) {
            this.log.warn("Filename has no extensions " + file.toString());
        } else {
            String extension = name.substring(extensionIndex, name.length());
            if (this.mimeTypes.containsKey(extension)) {
                mime = (String)this.mimeTypes.get(extension);
                found = true;
            } else {
                this.log.warn("MIME type not found " + extension);
            }
        }
        if (found) {
            try {
                this.log.debug("Reading file");
                BufferedInputStream fileIn = new BufferedInputStream(this.getInputStream(path));
                ByteArrayOutputStream outArray = new ByteArrayOutputStream();
                BufferedOutputStream outBuffer = new BufferedOutputStream(outArray);
                int piece = 0;
                while ((piece = fileIn.read()) >= 0) {
                    outBuffer.write(piece);
                }
                outBuffer.flush();
                out.setCode(200);
                out.setHeader("Content-type", mime);
                out.sendHeaders();
                this.log.debug("File output " + mime);
                outArray.writeTo(out);
                fileIn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                found = false;
            }
        }
        if (!found) {
            throw new HttpException(404, "file not found");
        }
        return null;
    }

    protected InputStream getInputStream(String path) {
        InputStream file = null;
        if (!this.useJar) {
            try {
                file = new FileInputStream(new File(this.root, path));
            }
            catch (FileNotFoundException e) {
                this.log.error("File not found", e);
            }
        } else {
            String targetFile = this.path;
            targetFile = path.startsWith("/") ? targetFile + path : targetFile + "/" + path;
            if (this.root != null) {
                file = this.targetClassLoader.getResourceAsStream(targetFile);
            }
            if (file == null) {
                file = this.getClass().getClassLoader().getResourceAsStream(targetFile);
            }
        }
        return file;
    }

    public Source resolve(String href, String base) {
        return new StreamSource(this.getInputStream(href));
    }

    public void setFile(String file) {
        if (file != null) {
            File target = new File(file);
            if (!target.exists()) {
                this.log.warn("Target file does not exist, defaulting to previous");
                return;
            }
            if (target.isDirectory()) {
                this.useJar = false;
                this.log.info("Using " + file + " as the root dir");
                this.root = target;
                return;
            }
            if (target.isFile() && (target.getName().endsWith(".jar") || target.getName().endsWith(".zip"))) {
                try {
                    URL url = target.toURL();
                    this.targetClassLoader = new URLClassLoader(new URL[]{url});
                    this.log.info("Using compressed file " + url + " as the root file");
                    this.root = target;
                    this.useJar = true;
                }
                catch (MalformedURLException e) {
                    this.log.warn("Unable to create class loader", e);
                }
            } else {
                this.log.warn("Target file does not exist, defaulting to previous");
            }
        }
    }

    public String getFile() {
        return this.root != null ? this.root.getName() : null;
    }

    public String getPathInJar() {
        return this.path;
    }

    public void setPathInJar(String path) {
        this.path = path;
    }

    public boolean isUseJar() {
        return this.useJar;
    }

    public boolean isUsePath() {
        return !this.useJar;
    }

    public void addMimeType(String extension, String type) {
        if (extension != null && type != null) {
            this.log.info("Added MIME type " + type + " for extension " + extension);
            this.mimeTypes.put(extension, type);
        }
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public String getName() {
        return "XSLT Processor";
    }
}

