/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.xml.parsers.DocumentBuilder;
import mx4j.adaptor.http.HttpCommandProcessor;
import mx4j.adaptor.http.HttpInputStream;
import mx4j.adaptor.http.HttpUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class MBeanCommandProcessor
implements HttpCommandProcessor {
    private MBeanServer server;
    private DocumentBuilder builder;

    public MBeanCommandProcessor(MBeanServer server, DocumentBuilder builder) {
        this.server = server;
        this.builder = builder;
    }

    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        String name = in.getVariable("objectname");
        ObjectName objectName = null;
        boolean validMBean = false;
        if (name != null && this.server.isRegistered(objectName = new ObjectName(name))) {
            validMBean = true;
        }
        if (validMBean) {
            MBeanNotificationInfo[] notifications;
            MBeanOperationInfo[] operations;
            MBeanConstructorInfo[] constructors;
            int i;
            MBeanAttributeInfo[] attributes;
            Element root = document.createElement("MBean");
            document.appendChild(root);
            MBeanInfo info = this.server.getMBeanInfo(objectName);
            root.setAttribute("description", info.getDescription());
            root.setAttribute("classname", info.getClassName());
            root.setAttribute("objectname", objectName.toString());
            boolean isModel = false;
            if (info instanceof ModelMBeanInfo) {
                isModel = true;
                root.setAttribute("model", "true");
            }
            if (HttpUtil.booleanVariableValue(in, "attributes", true) && (attributes = info.getAttributes()) != null) {
                i = 0;
                while (i < attributes.length) {
                    Element attribute = document.createElement("Attribute");
                    attribute.setAttribute("name", attributes[i].getName());
                    attribute.setAttribute("type", attributes[i].getType());
                    attribute.setAttribute("description", attributes[i].getDescription());
                    if (attributes[i].isReadable() && attributes[i].isWritable()) {
                        attribute.setAttribute("availability", "RW");
                    }
                    if (attributes[i].isReadable() && !attributes[i].isWritable()) {
                        attribute.setAttribute("availability", "RO");
                    }
                    if (!attributes[i].isReadable() && attributes[i].isWritable()) {
                        attribute.setAttribute("availability", "WO");
                    }
                    try {
                        Object attributeValue = this.server.getAttribute(objectName, attributes[i].getName());
                        if (attributeValue != null) {
                            attribute.setAttribute("value", attributeValue.toString());
                        } else {
                            attribute.setAttribute("value", "null");
                        }
                    }
                    catch (JMException e) {
                        attribute.setAttribute("value", e.getMessage());
                    }
                    root.appendChild(attribute);
                    ++i;
                }
            }
            if (HttpUtil.booleanVariableValue(in, "constructors", true) && (constructors = info.getConstructors()) != null) {
                i = 0;
                while (i < constructors.length) {
                    Element constructor = document.createElement("Constructor");
                    constructor.setAttribute("name", constructors[i].getName());
                    constructor.setAttribute("description", constructors[i].getDescription());
                    this.addParameters(constructor, document, constructors[i].getSignature());
                    root.appendChild(constructor);
                    ++i;
                }
            }
            if (HttpUtil.booleanVariableValue(in, "operations", true) && (operations = info.getOperations()) != null) {
                i = 0;
                while (i < operations.length) {
                    Element operation = document.createElement("Operation");
                    operation.setAttribute("name", operations[i].getName());
                    operation.setAttribute("description", operations[i].getDescription());
                    operation.setAttribute("return", operations[i].getReturnType());
                    switch (operations[i].getImpact()) {
                        case 3: {
                            operation.setAttribute("impact", "unknown");
                            break;
                        }
                        case 1: {
                            operation.setAttribute("impact", "action");
                            break;
                        }
                        case 0: {
                            operation.setAttribute("impact", "info");
                            break;
                        }
                        case 2: {
                            operation.setAttribute("impact", "action_info");
                        }
                    }
                    this.addParameters(operation, document, operations[i].getSignature());
                    root.appendChild(operation);
                    ++i;
                }
            }
            if (HttpUtil.booleanVariableValue(in, "notifications", true) && (notifications = info.getNotifications()) != null) {
                i = 0;
                while (i < notifications.length) {
                    Element notification = document.createElement("Notification");
                    notification.setAttribute("name", notifications[i].getName());
                    notification.setAttribute("description", notifications[i].getDescription());
                    String[] types = notifications[i].getNotifTypes();
                    int j = 0;
                    while (j < types.length) {
                        Element type = document.createElement("Type");
                        type.setAttribute("name", types[j]);
                        notification.appendChild(type);
                        ++j;
                    }
                    root.appendChild(notification);
                    ++i;
                }
            }
        }
        return document;
    }

    protected void addParameters(Element node, Document document, MBeanParameterInfo[] parameters) {
        int j = 0;
        while (j < parameters.length) {
            Element parameter = document.createElement("Parameter");
            parameter.setAttribute("name", parameters[j].getName());
            parameter.setAttribute("description", parameters[j].getDescription());
            parameter.setAttribute("type", parameters[j].getType());
            parameter.setAttribute("id", "" + j);
            node.appendChild(parameter);
            ++j;
        }
    }
}

