/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import mx4j.adaptor.http.HttpCommandProcessor;
import mx4j.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DeleteMBeanCommandProcessor
implements HttpCommandProcessor {
    private MBeanServer server;
    private DocumentBuilder builder;

    public DeleteMBeanCommandProcessor(MBeanServer server, DocumentBuilder builder) {
        this.server = server;
        this.builder = builder;
    }

    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        Element root = document.createElement("MBeanOperation");
        document.appendChild(root);
        Element operationElement = document.createElement("Operation");
        operationElement.setAttribute("operation", "delete");
        root.appendChild(operationElement);
        String objectVariable = in.getVariable("objectname");
        operationElement.setAttribute("objectname", objectVariable);
        if (objectVariable == null || objectVariable.equals("")) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", "Incorrect parameters in the request");
            return document;
        }
        ObjectName name = null;
        try {
            name = new ObjectName(objectVariable);
        }
        catch (MalformedObjectNameException e) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", "Malformed object name");
            return document;
        }
        if (this.server.isRegistered(name)) {
            try {
                this.server.unregisterMBean(name);
                operationElement.setAttribute("result", "success");
            }
            catch (Exception e) {
                operationElement.setAttribute("result", "error");
                operationElement.setAttribute("errorMsg", e.getMessage());
            }
        } else if (name != null) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", "MBean " + name + " not registered");
        }
        return document;
    }
}

