/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.rmi;

import java.io.IOException;
import java.rmi.MarshalledObject;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import mx4j.server.ChainedMBeanServer;

public class UnmarshallingMBeanServer
extends ChainedMBeanServer {
    public UnmarshallingMBeanServer(MBeanServer server) {
        super(server);
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            Object[] unmarshalled = this.unmarshalObjects(args);
            return super.createMBean(className, objectName, unmarshalled, parameters);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
        catch (IOException x) {
            throw new ReflectionException(x);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] args, String[] parameters) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            Object[] unmarshalled = this.unmarshalObjects(args);
            return super.createMBean(className, objectName, loaderName, unmarshalled, parameters);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
        catch (IOException x) {
            throw new ReflectionException(x);
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            attribute = this.unmarshalAttribute(attribute);
            super.setAttribute(objectName, attribute);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
        catch (IOException x) {
            throw new ReflectionException(x);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        try {
            AttributeList list = new AttributeList();
            int i = 0;
            while (i < attributes.size()) {
                Attribute attribute = (Attribute)attributes.get(i);
                attribute = this.unmarshalAttribute(attribute);
                list.add(attribute);
                ++i;
            }
            return super.setAttributes(objectName, list);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
        catch (IOException x) {
            throw new ReflectionException(x);
        }
    }

    public Object invoke(ObjectName objectName, String methodName, Object[] args, String[] parameters) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            Object[] unmarshalled = this.unmarshalObjects(args);
            return super.invoke(objectName, methodName, unmarshalled, parameters);
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
        catch (IOException x) {
            throw new ReflectionException(x);
        }
    }

    private Object[] unmarshalObjects(Object[] args) throws ClassNotFoundException, IOException {
        if (args == null) {
            return null;
        }
        Object[] unmarshalled = new Object[args.length];
        int i = 0;
        while (i < unmarshalled.length) {
            Object arg = args[i];
            unmarshalled[i] = this.unmarshalObject(arg);
            ++i;
        }
        return unmarshalled;
    }

    private Object unmarshalObject(Object obj) throws ClassNotFoundException, IOException {
        if (obj instanceof MarshalledObject) {
            return ((MarshalledObject)obj).get();
        }
        return obj;
    }

    private Attribute unmarshalAttribute(Attribute attribute) throws ClassNotFoundException, IOException {
        Object unmarshalled;
        Object value = attribute.getValue();
        if (value != (unmarshalled = this.unmarshalObject(value))) {
            attribute = new Attribute(attribute.getName(), unmarshalled);
        }
        return attribute;
    }
}

