/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote.resolver.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.rmi.Remote;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Hashtable;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.management.remote.rmi.RMIServer;
import javax.management.remote.rmi.RMIServerImpl;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import mx4j.log.Logger;
import mx4j.remote.ConnectionResolver;
import mx4j.util.Base64Codec;

public class RMIResolver
extends ConnectionResolver {
    private static final String JNDI_CONTEXT = "/jndi/";
    private static final String STUB_CONTEXT = "/stub/";

    public Object lookupClient(JMXServiceURL url, Map environment) throws IOException {
        return this.lookupRMIServerStub(url, environment);
    }

    public Object bindClient(Object client, Map environment) throws IOException {
        return client;
    }

    protected RMIServer lookupRMIServerStub(JMXServiceURL url, Map environment) throws IOException {
        Logger logger = RMIResolver.getLogger();
        String path = url.getURLPath();
        if (logger.isEnabledFor(10)) {
            logger.debug("JMXServiceURL for lookup is: '" + url + "'");
        }
        if (path != null) {
            if (path.startsWith(JNDI_CONTEXT)) {
                return this.lookupStubInJNDI(url, environment);
            }
            return this.decodeStub(url, environment);
        }
        throw new MalformedURLException("Unsupported lookup " + url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RMIServer lookupStubInJNDI(JMXServiceURL url, Map environment) throws IOException {
        RMIServer rMIServer;
        Logger logger = RMIResolver.getLogger();
        String path = url.getURLPath();
        String name = path.substring(JNDI_CONTEXT.length());
        if (logger.isEnabledFor(10)) {
            logger.debug("Looking up RMI stub in JNDI under name " + name);
        }
        InitialContext ctx = null;
        try {
            try {
                ctx = new InitialContext(new Hashtable(environment));
                Object stub = ctx.lookup(name);
                if (logger.isEnabledFor(10)) {
                    logger.debug("Found RMI stub in JNDI " + stub);
                }
                rMIServer = this.narrowRMIServerStub(stub);
                Object var10_10 = null;
            }
            catch (NamingException x) {
                if (!logger.isEnabledFor(10)) throw new IOException(x.toString());
                logger.debug("Cannot lookup RMI stub in JNDI", x);
                throw new IOException(x.toString());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (ctx == null) throw throwable;
                ctx.close();
                throw throwable;
            }
            catch (NamingException x2) {
                if (!logger.isEnabledFor(10)) throw throwable;
                logger.debug("Cannot close InitialContext", x2);
                throw throwable;
            }
        }
        try {}
        catch (NamingException x2) {
            if (!logger.isEnabledFor(10)) return rMIServer;
            logger.debug("Cannot close InitialContext", x2);
            return rMIServer;
        }
        if (ctx == null) return rMIServer;
        ctx.close();
        return rMIServer;
    }

    protected RMIServer narrowRMIServerStub(Object stub) {
        return (RMIServer)stub;
    }

    protected RMIServer decodeStub(JMXServiceURL url, Map environment) throws IOException {
        String path = url.getURLPath();
        if (path.startsWith(STUB_CONTEXT)) {
            byte[] encoded = path.substring(STUB_CONTEXT.length()).getBytes();
            if (!Base64Codec.isArrayByteBase64(encoded)) {
                throw new IOException("Encoded stub form is not a valid Base64 sequence: " + url);
            }
            byte[] decoded = Base64Codec.decodeBase64(encoded);
            ByteArrayInputStream bais = new ByteArrayInputStream(decoded);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(bais);
                RMIServer rMIServer = (RMIServer)ois.readObject();
                return rMIServer;
            }
            catch (ClassNotFoundException x) {
                throw new IOException("Cannot decode stub from " + url + ": " + x);
            }
            finally {
                if (ois != null) {
                    ois.close();
                }
            }
        }
        throw new MalformedURLException("Unsupported binding: " + url);
    }

    public Object createServer(JMXServiceURL url, Map environment) throws IOException {
        return this.createRMIServer(url, environment);
    }

    protected RMIServerImpl createRMIServer(JMXServiceURL url, Map environment) throws IOException {
        int port = url.getPort();
        RMIClientSocketFactory clientFactory = (RMIClientSocketFactory)environment.get("jmx.remote.rmi.client.socket.factory");
        RMIServerSocketFactory serverFactory = (RMIServerSocketFactory)environment.get("jmx.remote.rmi.server.socket.factory");
        return new RMIJRMPServerImpl(port, clientFactory, serverFactory, environment);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMXServiceURL bindServer(Object server, JMXServiceURL url, Map environment) throws IOException {
        JMXServiceURL jMXServiceURL;
        RMIServerImpl rmiServer = (RMIServerImpl)server;
        Logger logger = RMIResolver.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("JMXServiceURL for binding is: '" + url + "'");
        }
        if (this.isEncodedForm(url)) {
            String path = this.encodeStub(rmiServer, environment);
            return new JMXServiceURL(url.getProtocol(), url.getHost(), url.getPort(), path);
        }
        String jndiURL = this.parseJNDIForm(url);
        if (logger.isEnabledFor(10)) {
            logger.debug("JMXServiceURL path for binding is: '" + jndiURL + "'");
        }
        InitialContext ctx = null;
        try {
            try {
                ctx = new InitialContext(new Hashtable(environment));
                boolean rebind = Boolean.valueOf((String)environment.get("jmx.remote.jndi.rebind"));
                if (rebind) {
                    ctx.rebind(jndiURL, (Object)rmiServer.toStub());
                } else {
                    ctx.bind(jndiURL, (Object)rmiServer.toStub());
                }
                if (logger.isEnabledFor(10)) {
                    logger.debug("Bound " + rmiServer + " to " + jndiURL);
                }
                jMXServiceURL = url;
                Object var11_12 = null;
            }
            catch (NamingException x) {
                if (!logger.isEnabledFor(10)) throw new IOException(x.toString());
                logger.debug("Cannot bind server " + rmiServer + " to " + jndiURL, x);
                throw new IOException(x.toString());
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                if (ctx == null) throw throwable;
                ctx.close();
                throw throwable;
            }
            catch (NamingException x2) {
                if (!logger.isEnabledFor(10)) throw throwable;
                logger.debug("Cannot close InitialContext", x2);
                throw throwable;
            }
        }
        try {}
        catch (NamingException x2) {
            if (!logger.isEnabledFor(10)) return jMXServiceURL;
            logger.debug("Cannot close InitialContext", x2);
            return jMXServiceURL;
        }
        if (ctx == null) return jMXServiceURL;
        ctx.close();
        return jMXServiceURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String encodeStub(RMIServerImpl rmiServer, Map environment) throws IOException {
        Remote stub = rmiServer.toStub();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(stub);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        byte[] bytes = baos.toByteArray();
        byte[] encoded = Base64Codec.encodeBase64(bytes);
        return STUB_CONTEXT + new String(encoded);
    }

    protected boolean isEncodedForm(JMXServiceURL url) {
        String path = url.getURLPath();
        return path == null || path.length() == 0 || path.equals("/") || path.startsWith(STUB_CONTEXT);
    }

    private String parseJNDIForm(JMXServiceURL url) throws MalformedURLException {
        String path = url.getURLPath();
        if (path.startsWith(JNDI_CONTEXT)) {
            String jndiURL = path.substring(JNDI_CONTEXT.length());
            if (jndiURL == null || jndiURL.length() == 0) {
                throw new MalformedURLException("No JNDI URL specified: " + url);
            }
            return jndiURL;
        }
        throw new MalformedURLException("Unsupported binding: " + url);
    }

    /*
     * Loose catch block
     */
    public void unbindServer(Object server, JMXServiceURL url, Map environment) throws IOException {
        block15: {
            InitialContext ctx;
            String jndiURL;
            Logger logger;
            block14: {
                logger = RMIResolver.getLogger();
                if (logger.isEnabledFor(10)) {
                    logger.debug("JMXServiceURL for unbinding is: '" + url + "'");
                }
                if (this.isEncodedForm(url)) {
                    this.destroyServer(server, environment);
                    return;
                }
                jndiURL = this.parseJNDIForm(url);
                if (logger.isEnabledFor(10)) {
                    logger.debug("JMXServiceURL path for binding is: '" + jndiURL + "'");
                }
                ctx = null;
                ctx = new InitialContext(new Hashtable(environment));
                ctx.unbind(jndiURL);
                if (!logger.isEnabledFor(10)) break block14;
                logger.debug("Unbound " + server + " from " + jndiURL);
            }
            Object var9_7 = null;
            try {
                if (ctx != null) {
                    ctx.close();
                }
                break block15;
            }
            catch (NamingException x) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Cannot close InitialContext", x);
                }
                break block15;
            }
            {
                catch (NamingException x) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Cannot unbind server " + server + " to " + jndiURL, x);
                    }
                    throw new IOException(x.toString());
                }
            }
            catch (Throwable throwable) {
                block16: {
                    Object var9_8 = null;
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (NamingException x) {
                        if (!logger.isEnabledFor(10)) break block16;
                        logger.debug("Cannot close InitialContext", x);
                    }
                }
                throw throwable;
            }
        }
    }

    protected void destroyServer(Object server, Map environment) throws IOException {
    }
}

