/*
 * Decompiled with CFR 0.152.
 */
package mx4j.examples.remote.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public class Client {
    public static void main(String[] args) throws Exception {
        JMXServiceURL url = new JMXServiceURL("rmi", "localhost", 0, "/jndi/jmx");
        HashMap<String, String[]> environment = new HashMap<String, String[]>();
        String[] credentials = new String[]{"guest", "guest"};
        environment.put("jmx.remote.credentials", credentials);
        JMXConnector cntor = JMXConnectorFactory.connect(url, environment);
        JMXPrincipal principal = new JMXPrincipal("anotherGuest");
        HashSet<JMXPrincipal> principals = new HashSet<JMXPrincipal>();
        principals.add(principal);
        Subject delegate = new Subject(true, principals, Collections.EMPTY_SET, Collections.EMPTY_SET);
        MBeanServerConnection connection = cntor.getMBeanServerConnection();
        MBeanServerConnection delegateConnection = cntor.getMBeanServerConnection(delegate);
        Set<ObjectName> mbeans = connection.queryNames(null, null);
        System.out.println("MBeans retrieved by a connection without delegate subject:");
        System.out.println(mbeans);
        System.out.println();
        mbeans = delegateConnection.queryNames(null, null);
        System.out.println("MBeans retrieved by a connection with a delegate subject:");
        System.out.println(mbeans);
        System.out.println();
        try {
            connection.getObjectInstance(ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate"));
            throw new Error();
        }
        catch (SecurityException x) {
            System.out.println("No permission to call getObjectInstance for the MBeanServerDelegate");
            return;
        }
    }
}

