/*
 * Decompiled with CFR 0.152.
 */
package mx4j.examples.mbeans.legacy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import mx4j.AbstractDynamicMBean;
import mx4j.examples.mbeans.legacy.LegacyService;

public class DynamicLegacyService
extends AbstractDynamicMBean
implements NotificationBroadcaster {
    private LegacyService service;
    private Thread statusThread;
    private NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
    static /* synthetic */ Class class$javax$management$Notification;

    public DynamicLegacyService(LegacyService service) {
        this.service = service;
        this.statusThread = new Thread(new Runnable(){

            public void run() {
                DynamicLegacyService.this.monitorStatus();
            }
        });
    }

    public void start() {
        this.statusThread.start();
        this.service.execute();
    }

    public boolean isRunning() {
        try {
            Class<?> cls = this.service.getClass();
            Method method = cls.getDeclaredMethod("isRunning", new Class[0]);
            method.setAccessible(true);
            Boolean result = (Boolean)method.invoke((Object)this.service, new Object[0]);
            return result;
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return false;
        }
    }

    public int getThreadCount() {
        try {
            Class<?> cls = this.service.getClass();
            Field field = cls.getDeclaredField("group");
            field.setAccessible(true);
            ThreadGroup group = (ThreadGroup)field.get(this.service);
            return group.activeCount();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return 0;
        }
    }

    private void monitorStatus() {
        boolean wasRunning = false;
        while (true) {
            boolean isRunning;
            if (wasRunning ^ (isRunning = this.isRunning())) {
                Notification notification = new Notification("legacy.status.running." + isRunning, (Object)this, 0L, "Legacy Service Status: " + isRunning);
                this.broadcaster.sendNotification(notification);
                wasRunning = isRunning;
            } else if (isRunning) {
                System.out.println("Threads: " + this.getThreadCount());
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected MBeanAttributeInfo[] createMBeanAttributeInfo() {
        return new MBeanAttributeInfo[]{new MBeanAttributeInfo("Running", "boolean", "The running status of the Legacy Service", true, false, true), new MBeanAttributeInfo("ThreadCount", "int", "The number of running threads", true, false, false)};
    }

    protected MBeanOperationInfo[] createMBeanOperationInfo() {
        return new MBeanOperationInfo[]{new MBeanOperationInfo("start", "Start the Legacy Service", new MBeanParameterInfo[0], "void", 1)};
    }

    protected MBeanNotificationInfo[] createMBeanNotificationInfo() {
        return this.getNotificationInfo();
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"legacy.status.running.true", "legacy.status.running.false"}, (class$javax$management$Notification == null ? (class$javax$management$Notification = DynamicLegacyService.class$("javax.management.Notification")) : class$javax$management$Notification).getName(), "Notifications on the status of the Legacy Service")};
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

