/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.jms;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationValue;
import com.mockobjects.MockObject;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import junit.framework.AssertionFailedError;

public class MockMessageConsumer
extends MockObject
implements MessageConsumer {
    private Message myMessage;
    private boolean myExpiresOnTimeout = false;
    private JMSException myException;
    protected ExpectationCounter myCloseCalls = new ExpectationCounter("MockMessageConsumer.close");
    protected ExpectationCounter myReceiveCalls = new ExpectationCounter("MockMessageConsumer.receive");
    private ExpectationValue messageListener = new ExpectationValue("messageListener");

    public void setExpectedMessageListener(MessageListener messageListener) {
        this.messageListener.setExpected((Object)messageListener);
    }

    public void close() throws JMSException {
        this.throwExceptionIfAny();
        this.myCloseCalls.inc();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.notImplemented();
        return null;
    }

    public String getMessageSelector() throws JMSException {
        this.notImplemented();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive() throws JMSException {
        this.throwExceptionIfAny();
        this.myReceiveCalls.inc();
        if (this.myExpiresOnTimeout) {
            MockMessageConsumer mockMessageConsumer = this;
            synchronized (mockMessageConsumer) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    throw new AssertionFailedError("Thread interrupted");
                }
            }
        }
        return this.myMessage;
    }

    public Message receive(long timeout) throws JMSException {
        this.throwExceptionIfAny();
        this.myReceiveCalls.inc();
        if (this.myExpiresOnTimeout) {
            return null;
        }
        return this.myMessage;
    }

    public Message receiveNoWait() throws JMSException {
        this.throwExceptionIfAny();
        this.myReceiveCalls.inc();
        return this.myMessage;
    }

    public void setExpectedCloseCalls(int callCount) {
        this.myCloseCalls.setExpected(callCount);
    }

    public void setExpectedReceiveCalls(int callCount) {
        this.myReceiveCalls.setExpected(callCount);
    }

    public void setupReceivedMessage(Message message) {
        this.myMessage = message;
    }

    public void setupExpiresOnTimeout(boolean expiresOnTimeout) {
        this.myExpiresOnTimeout = expiresOnTimeout;
    }

    public void setupThrowException(JMSException e) {
        this.myException = e;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.messageListener.setActual((Object)messageListener);
    }

    protected void throwExceptionIfAny() throws JMSException {
        if (null != this.myException) {
            throw this.myException;
        }
    }
}

