/*
 * Decompiled with CFR 0.152.
 */
package ml.rugal.sshcommon.hibernate;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import ml.rugal.sshcommon.hibernate.Finder;
import ml.rugal.sshcommon.page.Pagination;
import ml.rugal.sshcommon.util.BeanUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.transform.ResultTransformer;
import org.springframework.util.Assert;

public abstract class HibernateSimpleDao {
    protected SessionFactory sessionFactory;
    protected static final String ORDER_ENTRIES = "orderEntries";

    protected List find(String hql, Object ... values) {
        return this.createQuery(hql, values).list();
    }

    protected Object findUnique(String hql, Object ... values) {
        return this.createQuery(hql, values).setMaxResults(1).uniqueResult();
    }

    protected Pagination find(Finder finder, int pageNo, int pageSize) {
        int totalCount = this.countQueryResult(finder);
        Pagination p = new Pagination(pageNo, pageSize, totalCount);
        if (totalCount < 1) {
            p.setList(new ArrayList());
            return p;
        }
        Query query = this.getSession().createQuery(finder.getOrigHql());
        finder.setParamsToQuery(query);
        query.setFirstResult(p.getFirstResult());
        query.setMaxResults(p.getPageSize());
        if (finder.isCacheable()) {
            query.setCacheable(true);
        }
        List list = query.list();
        p.setList(list);
        return p;
    }

    protected List find(Finder finder) {
        Query query = finder.createQuery(this.getSession());
        List list = query.list();
        return list;
    }

    protected Query createQuery(String queryString, Object ... values) {
        Assert.hasText((String)queryString);
        Query queryObject = this.getSession().createQuery(queryString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                queryObject.setParameter(i, values[i]);
            }
        }
        return queryObject;
    }

    protected Pagination findByCriteria(Criteria crit, int pageNo, int pageSize) {
        List orderEntries;
        CriteriaImpl impl = (CriteriaImpl)crit;
        Projection projection = impl.getProjection();
        ResultTransformer transformer = impl.getResultTransformer();
        try {
            orderEntries = (List)BeanUtils.getFieldValue(impl, ORDER_ENTRIES);
            BeanUtils.setFieldValue(impl, ORDER_ENTRIES, new ArrayList());
        }
        catch (Exception e) {
            throw new RuntimeException("cannot read/write 'orderEntries' from CriteriaImpl", e);
        }
        int totalCount = ((Number)crit.setProjection(Projections.rowCount()).uniqueResult()).intValue();
        Pagination p = new Pagination(pageNo, pageSize, totalCount);
        if (totalCount < 1) {
            p.setList(new ArrayList());
            return p;
        }
        crit.setProjection(projection);
        if (projection == null) {
            crit.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        if (transformer != null) {
            crit.setResultTransformer(transformer);
        }
        try {
            BeanUtils.setFieldValue(impl, ORDER_ENTRIES, orderEntries);
        }
        catch (Exception e) {
            throw new RuntimeException("set 'orderEntries' to CriteriaImpl faild", e);
        }
        crit.setFirstResult(p.getFirstResult());
        crit.setMaxResults(p.getPageSize());
        p.setList(crit.list());
        return p;
    }

    protected int countQueryResult(Finder finder) {
        Query query = this.getSession().createQuery(finder.getRowCountHql());
        finder.setParamsToQuery(query);
        if (finder.isCacheable()) {
            query.setCacheable(true);
        }
        return ((Number)query.iterate().next()).intValue();
    }

    @Resource
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected Session getSession() {
        Session session = this.sessionFactory.getCurrentSession();
        return session;
    }
}

