/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.DrawableCompat;
import me.zhanghai.android.materialprogressbar.IntrinsicPaddingDrawable;
import me.zhanghai.android.materialprogressbar.R;
import me.zhanghai.android.materialprogressbar.TintableDrawable;
import me.zhanghai.android.materialprogressbar.internal.ThemeUtils;

abstract class ProgressDrawableBase
extends Drawable
implements IntrinsicPaddingDrawable,
TintableDrawable {
    protected boolean mUseIntrinsicPadding = true;
    protected boolean mAutoMirrored;
    protected int mAlpha = 255;
    protected ColorFilter mColorFilter;
    protected ColorStateList mTintList;
    protected PorterDuff.Mode mTintMode = PorterDuff.Mode.SRC_IN;
    protected PorterDuffColorFilter mTintFilter;
    private Paint mPaint;

    public ProgressDrawableBase(Context context) {
        this.setAutoMirrored(true);
        int colorControlActivated = ThemeUtils.getColorFromAttrRes(R.attr.colorControlActivated, context);
        this.setTint(colorControlActivated);
    }

    @Override
    public boolean getUseIntrinsicPadding() {
        return this.mUseIntrinsicPadding;
    }

    @Override
    public void setUseIntrinsicPadding(boolean useIntrinsicPadding) {
        if (this.mUseIntrinsicPadding != useIntrinsicPadding) {
            this.mUseIntrinsicPadding = useIntrinsicPadding;
            this.invalidateSelf();
        }
    }

    public boolean isAutoMirrored() {
        return this.mAutoMirrored;
    }

    public void setAutoMirrored(boolean mirrored) {
        if (this.mAutoMirrored != mirrored) {
            this.mAutoMirrored = mirrored;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setAlpha(int alpha) {
        if (this.mAlpha != alpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
        this.invalidateSelf();
    }

    @Override
    public void setTint(@ColorInt int tintColor) {
        this.setTintList(ColorStateList.valueOf((int)tintColor));
    }

    @Override
    public void setTintList(@Nullable ColorStateList tint) {
        this.mTintList = tint;
        this.mTintFilter = this.makeTintFilter(this.mTintList, this.mTintMode);
        this.invalidateSelf();
    }

    @Override
    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.mTintMode = tintMode;
        this.mTintFilter = this.makeTintFilter(this.mTintList, this.mTintMode);
        this.invalidateSelf();
    }

    private PorterDuffColorFilter makeTintFilter(ColorStateList tint, PorterDuff.Mode tintMode) {
        if (tint == null || tintMode == null) {
            return null;
        }
        int color = tint.getColorForState(this.getState(), 0);
        return new PorterDuffColorFilter(color, tintMode);
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        if (bounds.width() == 0 || bounds.height() == 0) {
            return;
        }
        if (this.mPaint == null) {
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setColor(-16777216);
            this.onPreparePaint(this.mPaint);
        }
        this.mPaint.setAlpha(this.mAlpha);
        ColorFilter colorFilter = this.mColorFilter != null ? this.mColorFilter : this.mTintFilter;
        this.mPaint.setColorFilter(colorFilter);
        int saveCount = canvas.save();
        canvas.translate((float)bounds.left, (float)bounds.top);
        if (this.needMirroring()) {
            canvas.translate((float)bounds.width(), 0.0f);
            canvas.scale(-1.0f, 1.0f);
        }
        this.onDraw(canvas, bounds.width(), bounds.height(), this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    private boolean needMirroring() {
        return this.mAutoMirrored && DrawableCompat.getLayoutDirection((Drawable)this) == 1;
    }

    protected abstract void onPreparePaint(Paint var1);

    protected abstract void onDraw(Canvas var1, int var2, int var3, Paint var4);
}

