/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import me.zhanghai.android.materialprogressbar.SingleHorizontalProgressDrawable;
import me.zhanghai.android.materialprogressbar.internal.ThemeUtils;

public class HorizontalProgressDrawable
extends LayerDrawable {
    private int mSecondaryAlpha;
    private SingleHorizontalProgressDrawable mTrackDrawable;
    private SingleHorizontalProgressDrawable mSecondaryProgressDrawable;
    private SingleHorizontalProgressDrawable mProgressDrawable;

    public HorizontalProgressDrawable(Context context) {
        super(new Drawable[]{new SingleHorizontalProgressDrawable(context), new SingleHorizontalProgressDrawable(context), new SingleHorizontalProgressDrawable(context)});
        this.setId(0, 0x1020000);
        this.mTrackDrawable = (SingleHorizontalProgressDrawable)this.getDrawable(0);
        this.setId(1, 16908303);
        this.mSecondaryProgressDrawable = (SingleHorizontalProgressDrawable)this.getDrawable(1);
        float disabledAlpha = ThemeUtils.getAttrFloat(context, 0x1010033);
        this.mSecondaryAlpha = Math.round(disabledAlpha * 255.0f);
        this.mSecondaryProgressDrawable.setAlpha(this.mSecondaryAlpha);
        this.mSecondaryProgressDrawable.setShowTrack(false);
        this.setId(2, 16908301);
        this.mProgressDrawable = (SingleHorizontalProgressDrawable)this.getDrawable(2);
        this.mProgressDrawable.setShowTrack(false);
    }

    public boolean getShowTrack() {
        return this.mTrackDrawable.getShowTrack();
    }

    public void setShowTrack(boolean showTrack) {
        if (this.mTrackDrawable.getShowTrack() != showTrack) {
            this.mTrackDrawable.setShowTrack(showTrack);
            this.mSecondaryProgressDrawable.setAlpha(showTrack ? this.mSecondaryAlpha : 2 * this.mSecondaryAlpha);
        }
    }

    public boolean getUseIntrinsicPadding() {
        return this.mTrackDrawable.getUseIntrinsicPadding();
    }

    public void setUseIntrinsicPadding(boolean useIntrinsicPadding) {
        this.mTrackDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
        this.mSecondaryProgressDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
        this.mProgressDrawable.setUseIntrinsicPadding(useIntrinsicPadding);
    }

    @TargetApi(value=21)
    public void setTint(int tint) {
        this.mTrackDrawable.setTint(tint);
        this.mSecondaryProgressDrawable.setTint(tint);
        this.mProgressDrawable.setTint(tint);
    }

    @TargetApi(value=21)
    public void setTintList(ColorStateList tint) {
        this.mTrackDrawable.setTintList(tint);
        this.mSecondaryProgressDrawable.setTintList(tint);
        this.mProgressDrawable.setTintList(tint);
    }

    @TargetApi(value=21)
    public void setTintMode(PorterDuff.Mode tintMode) {
        this.mTrackDrawable.setTintMode(tintMode);
        this.mSecondaryProgressDrawable.setTintMode(tintMode);
        this.mProgressDrawable.setTintMode(tintMode);
    }
}

