/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Animatable;
import me.zhanghai.android.materialprogressbar.ProgressDrawableBase;

abstract class IndeterminateProgressDrawableBase
extends ProgressDrawableBase
implements Animatable {
    protected Animator[] mAnimators;

    public IndeterminateProgressDrawableBase(Context context) {
        super(context);
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.isStarted()) {
            this.invalidateSelf();
        }
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        for (Animator animator : this.mAnimators) {
            animator.start();
        }
        this.invalidateSelf();
    }

    private boolean isStarted() {
        for (Animator animator : this.mAnimators) {
            if (!animator.isStarted()) continue;
            return true;
        }
        return false;
    }

    public void stop() {
        for (Animator animator : this.mAnimators) {
            animator.end();
        }
    }

    public boolean isRunning() {
        for (Animator animator : this.mAnimators) {
            if (!animator.isRunning()) continue;
            return true;
        }
        return false;
    }
}

