/*
 * Decompiled with CFR 0.152.
 */
package me.shib.java.lib.telegram.bot.easybot;

import java.util.HashMap;
import java.util.Map;
import me.shib.java.lib.telegram.bot.easybot.BotConfig;
import me.shib.java.lib.telegram.bot.easybot.DefaultBotModel;
import me.shib.java.lib.telegram.bot.service.TelegramBot;

public class TBotSweeper
extends Thread {
    private static Map<String, TBotSweeper> tBotSweeperMap;
    private DefaultBotModel defaultModel;
    private BotConfig botConfig;
    private TelegramBot sweeperTelegramBot;

    private TBotSweeper(DefaultBotModel defaultModel) {
        this.botConfig = defaultModel.getConfig();
        this.defaultModel = defaultModel;
        this.sweeperTelegramBot = TelegramBot.getInstance((String)this.botConfig.getBotApiToken());
    }

    private static synchronized TBotSweeper getDefaultInstance(DefaultBotModel defaultModel) {
        TBotSweeper tBotSwp;
        String botApiToken = defaultModel.getConfig().getBotApiToken();
        if (botApiToken == null) {
            return null;
        }
        if (tBotSweeperMap == null) {
            tBotSweeperMap = new HashMap<String, TBotSweeper>();
        }
        if ((tBotSwp = tBotSweeperMap.get(botApiToken)) == null) {
            tBotSwp = new TBotSweeper(defaultModel);
            tBotSweeperMap.put(botApiToken, tBotSwp);
        }
        return tBotSwp;
    }

    protected static synchronized void startDefaultInstance(DefaultBotModel defaultModel) {
        TBotSweeper defaultSweeper = TBotSweeper.getDefaultInstance(defaultModel);
        if (!defaultSweeper.isAlive() && defaultSweeper.getState() != Thread.State.TERMINATED) {
            defaultSweeper.start();
        }
    }

    private void sendStatusUpdatesOnIntervals() {
        long intervals = this.botConfig.getReportIntervalInSeconds() * 1000L;
        long[] adminIdList = this.botConfig.getAdminIdList();
        if (intervals > 0L && adminIdList != null && adminIdList.length > 0) {
            while (true) {
                try {
                    while (true) {
                        for (long admin : adminIdList) {
                            this.defaultModel.sendStatusMessage(admin);
                        }
                        Thread.sleep(intervals);
                    }
                }
                catch (Exception e) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public void run() {
        this.sendStatusUpdatesOnIntervals();
    }
}

