/*
 * Decompiled with CFR 0.152.
 */
package me.shib.java.lib.telegram.bot.easybot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.shib.java.lib.common.utils.JsonLib;
import me.shib.java.lib.telegram.bot.easybot.BotModel;

public class BotConfig {
    private static final File defaultConfigFile = new File("easy-tbot-config.json");
    private static final String[] defaultCommands = new String[]{"/start", "/status", "/scr", "/usermode", "/adminmode"};
    private static Map<String, BotConfig> configMap;
    private String botModelClassName;
    private String botApiToken;
    private String[] commandList;
    private int threadCount;
    private long[] adminIdList;
    private long reportIntervalInSeconds;
    private Map<String, String> constants;
    private Set<String> userModeSet;

    public BotConfig(String botApiToken, Class<BotModel> botModelClass) {
        this.botModelClassName = botModelClass.getName();
        this.botApiToken = botApiToken;
        this.adminIdList = null;
        this.initDefaults();
    }

    private static boolean isValidClassName(String className) {
        if (className == null) {
            return true;
        }
        try {
            if (!className.isEmpty()) {
                Class.forName(className);
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static synchronized BotConfig[] getAllConfigList() {
        if (configMap == null) {
            BotConfig.addFileToConfigList(defaultConfigFile);
        }
        if (configMap == null) {
            return null;
        }
        ArrayList<BotConfig> configList = new ArrayList<BotConfig>(configMap.values());
        BotConfig[] configArray = new BotConfig[configList.size()];
        return configList.toArray(configArray);
    }

    public static void addConfigToList(BotConfig config) {
        if (configMap == null) {
            configMap = new HashMap<String, BotConfig>();
        }
        configMap.put(config.getBotApiToken(), config);
    }

    public static synchronized void addJSONtoConfigList(String json) {
        BotConfig[] configArray;
        if (json != null && (configArray = (BotConfig[])JsonLib.getDefaultInstance().fromJson(json, BotConfig[].class)) != null) {
            for (BotConfig configItem : configArray) {
                if (configItem.getBotApiToken() == null || configItem.getBotApiToken().isEmpty() || !BotConfig.isValidClassName(configItem.getBotModelClassName())) continue;
                configItem.initDefaults();
                BotConfig.addConfigToList(configItem);
            }
        }
    }

    public static synchronized void addFileToConfigList(File configFile) {
        if (configFile != null && configFile.exists()) {
            try {
                StringBuilder jsonBuilder = new StringBuilder();
                BufferedReader br = new BufferedReader(new FileReader(configFile));
                String line = br.readLine();
                while (line != null) {
                    jsonBuilder.append(line);
                    line = br.readLine();
                    if (line == null) continue;
                    jsonBuilder.append("\n");
                }
                br.close();
                BotConfig.addJSONtoConfigList(jsonBuilder.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean doesStringExistInList(String str, ArrayList<String> list) {
        for (String item : list) {
            if (!item.equals(str)) continue;
            return true;
        }
        return false;
    }

    private void initDefaults() {
        this.userModeSet = new HashSet<String>();
        if (this.commandList == null) {
            this.commandList = defaultCommands;
        } else {
            ArrayList<String> newCommandList = new ArrayList<String>();
            for (String command : this.commandList) {
                if (this.doesStringExistInList(command, newCommandList)) continue;
                newCommandList.add(command);
            }
            if (defaultCommands != null) {
                for (String command : defaultCommands) {
                    if (this.doesStringExistInList(command, newCommandList)) continue;
                    newCommandList.add(command);
                }
            }
            this.commandList = new String[newCommandList.size()];
            this.commandList = newCommandList.toArray(this.commandList);
        }
        if (this.reportIntervalInSeconds < 0L) {
            this.reportIntervalInSeconds = 0L;
        }
        if (this.constants == null) {
            this.constants = new HashMap<String, String>();
        }
        if (this.threadCount < 1) {
            this.threadCount = 1;
        }
    }

    public String getConstant(String key) {
        return this.constants.get(key);
    }

    public String getBotApiToken() {
        return this.botApiToken;
    }

    public boolean isValidCommand(String messageText) {
        String[] words;
        if (messageText != null && this.commandList != null && (words = messageText.split("\\s+")).length > 0) {
            String possibleCommand = words[0];
            for (String command : this.commandList) {
                if (!command.equals(possibleCommand)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isUserMode(long userId) {
        return this.userModeSet.contains(userId + "");
    }

    protected void setAdminMode(long userId) {
        this.userModeSet.remove(userId + "");
    }

    protected void setUserMode(long userId) {
        this.userModeSet.add(userId + "");
    }

    public long[] getAdminIdList() {
        return this.adminIdList;
    }

    public boolean isAdmin(long senderId) {
        if (this.adminIdList != null) {
            for (long adminId : this.adminIdList) {
                if (senderId != adminId) continue;
                return true;
            }
        }
        return false;
    }

    public long getReportIntervalInSeconds() {
        return this.reportIntervalInSeconds;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public String getBotModelClassName() {
        return this.botModelClassName;
    }
}

