/*
 * Decompiled with CFR 0.152.
 */
package me.saket.bettermovementmethod;

import android.app.Activity;
import android.graphics.RectF;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.BackgroundColorSpan;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.TextView;
import me.saket.bettermovementmethod.R;

public class BetterLinkMovementMethod
extends LinkMovementMethod {
    private static BetterLinkMovementMethod singleInstance;
    private static final int LINKIFY_NONE = -2;
    private OnLinkClickListener onLinkClickListener;
    private OnLinkLongClickListener onLinkLongClickListener;
    private final RectF touchedLineBounds = new RectF();
    private boolean isUrlHighlighted;
    private ClickableSpan clickableSpanUnderTouchOnActionDown;
    private int activeTextViewHashcode;
    private LongPressTimer ongoingLongPressTimer;
    private boolean wasLongPressRegistered;

    public static BetterLinkMovementMethod newInstance() {
        return new BetterLinkMovementMethod();
    }

    public static BetterLinkMovementMethod linkify(int linkifyMask, TextView ... textViews) {
        BetterLinkMovementMethod movementMethod = BetterLinkMovementMethod.newInstance();
        for (TextView textView : textViews) {
            BetterLinkMovementMethod.addLinks(linkifyMask, movementMethod, textView);
        }
        return movementMethod;
    }

    public static BetterLinkMovementMethod linkifyHtml(TextView ... textViews) {
        return BetterLinkMovementMethod.linkify(-2, textViews);
    }

    public static BetterLinkMovementMethod linkify(int linkifyMask, ViewGroup viewGroup) {
        BetterLinkMovementMethod movementMethod = BetterLinkMovementMethod.newInstance();
        BetterLinkMovementMethod.rAddLinks(linkifyMask, viewGroup, movementMethod);
        return movementMethod;
    }

    public static BetterLinkMovementMethod linkifyHtml(ViewGroup viewGroup) {
        return BetterLinkMovementMethod.linkify(-2, viewGroup);
    }

    public static BetterLinkMovementMethod linkify(int linkifyMask, Activity activity) {
        ViewGroup activityLayout = (ViewGroup)((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        BetterLinkMovementMethod movementMethod = BetterLinkMovementMethod.newInstance();
        BetterLinkMovementMethod.rAddLinks(linkifyMask, activityLayout, movementMethod);
        return movementMethod;
    }

    public static BetterLinkMovementMethod linkifyHtml(Activity activity) {
        return BetterLinkMovementMethod.linkify(-2, activity);
    }

    public static BetterLinkMovementMethod getInstance() {
        if (singleInstance == null) {
            singleInstance = new BetterLinkMovementMethod();
        }
        return singleInstance;
    }

    protected BetterLinkMovementMethod() {
    }

    public BetterLinkMovementMethod setOnLinkClickListener(OnLinkClickListener clickListener) {
        if (this == singleInstance) {
            throw new UnsupportedOperationException("Setting a click listener on the instance returned by getInstance() is not supported to avoid memory leaks. Please use newInstance() or any of the linkify() methods instead.");
        }
        this.onLinkClickListener = clickListener;
        return this;
    }

    public BetterLinkMovementMethod setOnLinkLongClickListener(OnLinkLongClickListener longClickListener) {
        if (this == singleInstance) {
            throw new UnsupportedOperationException("Setting a long-click listener on the instance returned by getInstance() is not supported to avoid memory leaks. Please use newInstance() or any of the linkify() methods instead.");
        }
        this.onLinkLongClickListener = longClickListener;
        return this;
    }

    private static void rAddLinks(int linkifyMask, ViewGroup viewGroup, BetterLinkMovementMethod movementMethod) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            if (child instanceof ViewGroup) {
                BetterLinkMovementMethod.rAddLinks(linkifyMask, (ViewGroup)child, movementMethod);
                continue;
            }
            if (!(child instanceof TextView)) continue;
            TextView textView = (TextView)child;
            BetterLinkMovementMethod.addLinks(linkifyMask, movementMethod, textView);
        }
    }

    private static void addLinks(int linkifyMask, BetterLinkMovementMethod movementMethod, TextView textView) {
        textView.setMovementMethod((MovementMethod)movementMethod);
        if (linkifyMask != -2) {
            Linkify.addLinks((TextView)textView, (int)linkifyMask);
        }
    }

    public boolean onTouchEvent(final TextView textView, Spannable text, MotionEvent event) {
        if (this.activeTextViewHashcode != textView.hashCode()) {
            this.activeTextViewHashcode = textView.hashCode();
            textView.setAutoLinkMask(0);
        }
        final ClickableSpan clickableSpanUnderTouch = this.findClickableSpanUnderTouch(textView, text, event);
        if (event.getAction() == 0) {
            this.clickableSpanUnderTouchOnActionDown = clickableSpanUnderTouch;
        }
        boolean touchStartedOverAClickableSpan = this.clickableSpanUnderTouchOnActionDown != null;
        switch (event.getAction()) {
            case 0: {
                if (clickableSpanUnderTouch != null) {
                    this.highlightUrl(textView, clickableSpanUnderTouch, text);
                }
                if (touchStartedOverAClickableSpan && this.onLinkLongClickListener != null) {
                    LongPressTimer.OnTimerReachedListener longClickListener = new LongPressTimer.OnTimerReachedListener(){

                        @Override
                        public void onTimerReached() {
                            BetterLinkMovementMethod.this.wasLongPressRegistered = true;
                            textView.performHapticFeedback(0);
                            BetterLinkMovementMethod.this.removeUrlHighlightColor(textView);
                            BetterLinkMovementMethod.this.dispatchUrlLongClick(textView, clickableSpanUnderTouch);
                        }
                    };
                    this.startTimerForRegisteringLongClick(textView, longClickListener);
                }
                return touchStartedOverAClickableSpan;
            }
            case 1: {
                if (!this.wasLongPressRegistered && touchStartedOverAClickableSpan && clickableSpanUnderTouch == this.clickableSpanUnderTouchOnActionDown) {
                    this.dispatchUrlClick(textView, clickableSpanUnderTouch);
                }
                this.cleanupOnTouchUp(textView);
                return touchStartedOverAClickableSpan;
            }
            case 3: {
                this.cleanupOnTouchUp(textView);
                return false;
            }
            case 2: {
                if (clickableSpanUnderTouch != this.clickableSpanUnderTouchOnActionDown) {
                    this.removeLongPressCallback(textView);
                }
                if (!this.wasLongPressRegistered) {
                    if (clickableSpanUnderTouch != null) {
                        this.highlightUrl(textView, clickableSpanUnderTouch, text);
                    } else {
                        this.removeUrlHighlightColor(textView);
                    }
                }
                return touchStartedOverAClickableSpan;
            }
        }
        return false;
    }

    private void cleanupOnTouchUp(TextView textView) {
        this.wasLongPressRegistered = false;
        this.clickableSpanUnderTouchOnActionDown = null;
        this.removeUrlHighlightColor(textView);
        this.removeLongPressCallback(textView);
    }

    protected ClickableSpan findClickableSpanUnderTouch(TextView textView, Spannable text, MotionEvent event) {
        int touchX = (int)event.getX();
        int touchY = (int)event.getY();
        touchX -= textView.getTotalPaddingLeft();
        touchY -= textView.getTotalPaddingTop();
        Layout layout = textView.getLayout();
        int touchedLine = layout.getLineForVertical(touchY += textView.getScrollY());
        int touchOffset = layout.getOffsetForHorizontal(touchedLine, (float)(touchX += textView.getScrollX()));
        this.touchedLineBounds.left = layout.getLineLeft(touchedLine);
        this.touchedLineBounds.top = layout.getLineTop(touchedLine);
        this.touchedLineBounds.right = layout.getLineWidth(touchedLine) + this.touchedLineBounds.left;
        this.touchedLineBounds.bottom = layout.getLineBottom(touchedLine);
        if (this.touchedLineBounds.contains((float)touchX, (float)touchY)) {
            Object[] spans;
            for (Object span : spans = text.getSpans(touchOffset, touchOffset, ClickableSpan.class)) {
                if (!(span instanceof ClickableSpan)) continue;
                return (ClickableSpan)span;
            }
            return null;
        }
        return null;
    }

    protected void highlightUrl(TextView textView, ClickableSpan clickableSpan, Spannable text) {
        if (this.isUrlHighlighted) {
            return;
        }
        this.isUrlHighlighted = true;
        int spanStart = text.getSpanStart((Object)clickableSpan);
        int spanEnd = text.getSpanEnd((Object)clickableSpan);
        BackgroundColorSpan highlightSpan = new BackgroundColorSpan(textView.getHighlightColor());
        text.setSpan((Object)highlightSpan, spanStart, spanEnd, 18);
        textView.setTag(R.id.bettermovementmethod_highlight_background_span, (Object)highlightSpan);
        Selection.setSelection((Spannable)text, (int)spanStart, (int)spanEnd);
    }

    protected void removeUrlHighlightColor(TextView textView) {
        if (!this.isUrlHighlighted) {
            return;
        }
        this.isUrlHighlighted = false;
        Spannable text = (Spannable)textView.getText();
        BackgroundColorSpan highlightSpan = (BackgroundColorSpan)textView.getTag(R.id.bettermovementmethod_highlight_background_span);
        text.removeSpan((Object)highlightSpan);
        Selection.removeSelection((Spannable)text);
    }

    protected void startTimerForRegisteringLongClick(TextView textView, LongPressTimer.OnTimerReachedListener longClickListener) {
        this.ongoingLongPressTimer = new LongPressTimer();
        this.ongoingLongPressTimer.setOnTimerReachedListener(longClickListener);
        textView.postDelayed((Runnable)this.ongoingLongPressTimer, (long)ViewConfiguration.getLongPressTimeout());
    }

    protected void removeLongPressCallback(TextView textView) {
        if (this.ongoingLongPressTimer != null) {
            textView.removeCallbacks((Runnable)this.ongoingLongPressTimer);
            this.ongoingLongPressTimer = null;
        }
    }

    protected void dispatchUrlClick(TextView textView, ClickableSpan clickableSpan) {
        boolean handled;
        ClickableSpanWithText clickableSpanWithText = ClickableSpanWithText.ofSpan(textView, clickableSpan);
        boolean bl = handled = this.onLinkClickListener != null && this.onLinkClickListener.onClick(textView, clickableSpanWithText.text());
        if (!handled) {
            clickableSpanWithText.span().onClick((View)textView);
        }
    }

    protected void dispatchUrlLongClick(TextView textView, ClickableSpan clickableSpan) {
        boolean handled;
        ClickableSpanWithText clickableSpanWithText = ClickableSpanWithText.ofSpan(textView, clickableSpan);
        boolean bl = handled = this.onLinkLongClickListener != null && this.onLinkLongClickListener.onLongClick(textView, clickableSpanWithText.text());
        if (!handled) {
            clickableSpanWithText.span().onClick((View)textView);
        }
    }

    protected static class ClickableSpanWithText {
        private ClickableSpan span;
        private String text;

        protected static ClickableSpanWithText ofSpan(TextView textView, ClickableSpan span) {
            String text;
            Spanned s = (Spanned)textView.getText();
            if (span instanceof URLSpan) {
                text = ((URLSpan)span).getURL();
            } else {
                int start = s.getSpanStart((Object)span);
                int end = s.getSpanEnd((Object)span);
                text = s.subSequence(start, end).toString();
            }
            return new ClickableSpanWithText(span, text);
        }

        protected ClickableSpanWithText(ClickableSpan span, String text) {
            this.span = span;
            this.text = text;
        }

        protected ClickableSpan span() {
            return this.span;
        }

        protected String text() {
            return this.text;
        }
    }

    protected static final class LongPressTimer
    implements Runnable {
        private OnTimerReachedListener onTimerReachedListener;

        protected LongPressTimer() {
        }

        @Override
        public void run() {
            this.onTimerReachedListener.onTimerReached();
        }

        public void setOnTimerReachedListener(OnTimerReachedListener listener) {
            this.onTimerReachedListener = listener;
        }

        protected static interface OnTimerReachedListener {
            public void onTimerReached();
        }
    }

    public static interface OnLinkLongClickListener {
        public boolean onLongClick(TextView var1, String var2);
    }

    public static interface OnLinkClickListener {
        public boolean onClick(TextView var1, String var2);
    }
}

