/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.log.logger;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.UUID;
import me.legrange.log.Event;
import me.legrange.log.Logger;
import me.legrange.log.logger.LoggerException;

public class NumberedExceptionLogger
implements Logger {
    private final Logger logger;
    private final PrintWriter out;

    public NumberedExceptionLogger(Logger logger, String exceptionFile) throws LoggerException {
        this(logger, NumberedExceptionLogger.openFile(exceptionFile));
    }

    public NumberedExceptionLogger(Logger logger, PrintWriter exceptionOut) throws LoggerException {
        this.logger = logger;
        this.out = exceptionOut;
    }

    @Override
    public synchronized void log(Event entry) {
        if (entry.getThrowable().isPresent()) {
            String id = this.getId();
            entry = new Event(entry.getMessage() + String.format(" [%s]", id), entry.getTimestamp(), entry.getLevel(), entry.getThrowable().get());
            this.writeToFile(id, entry);
        }
        this.logger.log(new Event(entry.getMessage(), entry.getTimestamp(), entry.getLevel()));
    }

    private String getId() {
        return UUID.randomUUID().toString();
    }

    private void writeToFile(String id, Event entry) {
        this.out.printf("[#%s - %s]\n", id, entry.getTimestamp());
        entry.getThrowable().get().printStackTrace(this.out);
        this.out.flush();
    }

    private static PrintWriter openFile(String fileName) throws LoggerException {
        try {
            return new PrintWriter(new FileWriter(fileName, true));
        }
        catch (IOException ex) {
            throw new LoggerException(String.format("Error opening log file '%s': %s", fileName, ex.getMessage()), ex);
        }
    }
}

