/*
 * Decompiled with CFR 0.152.
 */
package me.ccampo.spring.aws.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import me.ccampo.spring.aws.lambda.SpringRequestStreamHandler;
import org.jetbrains.annotations.NotNull;

public abstract class JacksonSpringRequestHandler<I, O>
extends SpringRequestStreamHandler {
    private final Class<I> inputClass;

    protected JacksonSpringRequestHandler(@NotNull Class<I> inputClass) {
        this.inputClass = inputClass;
    }

    protected abstract ObjectMapper getObjectMapper();

    @Override
    public void handleRequest(@NotNull InputStream input, @NotNull OutputStream output, @NotNull Context context) throws IOException {
        RequestHandler handler = (RequestHandler)this.getApplicationContext().getBean(RequestHandler.class);
        Object inObject = this.getObjectMapper().readValue(input, this.inputClass);
        Object outObject = handler.handleRequest(inObject, context);
        this.getObjectMapper().writeValue(output, outObject);
    }
}

