/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseSensorBridge;
import me.adaptive.arp.api.GeolocationListenerImpl;
import me.adaptive.arp.api.IGeolocation;
import me.adaptive.arp.api.IGeolocationListener;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.LoggingBridge;

public class GeolocationBridge
extends BaseSensorBridge
implements IGeolocation,
APIBridge {
    private IGeolocation delegate;

    public GeolocationBridge(IGeolocation delegate) {
        this.delegate = delegate;
    }

    public final IGeolocation getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IGeolocation delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addGeolocationListener(IGeolocationListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing addGeolocationListener...");
        }
        if (this.delegate != null) {
            this.delegate.addGeolocationListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'addGeolocationListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'addGeolocationListener'.");
        }
    }

    @Override
    public void removeGeolocationListener(IGeolocationListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeGeolocationListener...");
        }
        if (this.delegate != null) {
            this.delegate.removeGeolocationListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeGeolocationListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeGeolocationListener'.");
        }
    }

    @Override
    public void removeGeolocationListeners() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeGeolocationListeners...");
        }
        if (this.delegate != null) {
            this.delegate.removeGeolocationListeners();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeGeolocationListeners' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeGeolocationListeners'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "addGeolocationListener": {
                GeolocationListenerImpl listener0 = new GeolocationListenerImpl(request.getAsyncId());
                this.addGeolocationListener(listener0);
                break;
            }
            case "removeGeolocationListener": {
                GeolocationListenerImpl listener1 = new GeolocationListenerImpl(request.getAsyncId());
                this.removeGeolocationListener(listener1);
                break;
            }
            case "removeGeolocationListeners": {
                this.removeGeolocationListeners();
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "GeolocationBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.8.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

