/**
--| ADAPTIVE RUNTIME PLATFORM |----------------------------------------------------------------------------------------

(C) Copyright 2013-2015 Carlos Lozano Diez t/a Adaptive.me <http://adaptive.me>.

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the
License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 . Unless required by appli-
-cable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,  WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the  License  for the specific language governing
permissions and limitations under the License.

Original author:

    * Carlos Lozano Diez
            <http://github.com/carloslozano>
            <http://twitter.com/adaptivecoder>
            <mailto:carlos@adaptive.me>

Contributors:

    * Ferran Vila Conesa
             <http://github.com/fnva>
             <http://twitter.com/ferran_vila>
             <mailto:ferran.vila.conesa@gmail.com>

    * See source code files for contributors.

Release:

    * @version v2.2.8

-------------------------------------------| aut inveniam viam aut faciam |--------------------------------------------
*/

package me.adaptive.arp.api;

import com.google.gson.Gson;

/**
   Base application for Callback purposes
   Auto-generated implementation of IBaseCallback specification.
*/
public class BaseCallbackImpl implements IBaseCallback {

     /**
        Unique id of callback.
     */
     private long id;

     /**
        Group of API.
     */
     private IAdaptiveRPGroup apiGroup;

     /**
        Constructor with callback id.

        @param id  The id of the callback.
     */
     public BaseCallbackImpl(long id) {
          this.id = id;
          this.apiGroup = IAdaptiveRPGroup.Application;
     }

     /**
        Get the callback id.
        @return long with the identifier of the callback.
     */
     public final long getId() {
          return this.id;
     }

     /**
        Return the API group for the given interface.
     */
     @Override
     public IAdaptiveRPGroup getAPIGroup() {
          return this.apiGroup;
     }

     /**
        Return the API version for the given interface.
     */
     @Override
     public String getAPIVersion() {
          return "v2.2.8";
     }

     /**
        Return the JSON deserializer/serializer sourced from the static GsonBuilder.
        @return Gson new JSON deserializer/serializer instance from factory.
     */
     public final Gson getJSONParser() {
          return AppRegistryBridge.getJSONInstance().create();
     }

}
/**
------------------------------------| Engineered with ♥ in Barcelona, Catalonia |--------------------------------------
*/
