/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseSystemBridge;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.IRuntime;
import me.adaptive.arp.api.LoggingBridge;

public class RuntimeBridge
extends BaseSystemBridge
implements IRuntime,
APIBridge {
    private IRuntime delegate;

    public RuntimeBridge(IRuntime delegate) {
        this.delegate = delegate;
    }

    public final IRuntime getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IRuntime delegate) {
        this.delegate = delegate;
    }

    @Override
    public void dismissApplication() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing dismissApplication...");
        }
        if (this.delegate != null) {
            this.delegate.dismissApplication();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'dismissApplication' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'dismissApplication'.");
        }
    }

    @Override
    public boolean dismissSplashScreen() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing dismissSplashScreen...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.dismissSplashScreen();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'dismissSplashScreen' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'dismissSplashScreen'.");
        }
        return result;
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "dismissApplication": {
                this.dismissApplication();
                break;
            }
            case "dismissSplashScreen": {
                boolean response1 = this.dismissSplashScreen();
                responseJSON = AppRegistryBridge.escapeString(this.getJSONParser().toJson((Object)response1));
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "RuntimeBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.7.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

