/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.BaseUtilBridge;
import me.adaptive.arp.api.ILogging;
import me.adaptive.arp.api.ILoggingLogLevel;

public class LoggingBridge
extends BaseUtilBridge
implements ILogging,
APIBridge {
    private ILogging delegate;

    public LoggingBridge(ILogging delegate) {
        this.delegate = delegate;
    }

    public final ILogging getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(ILogging delegate) {
        this.delegate = delegate;
    }

    @Override
    public void log(ILoggingLogLevel level, String message) {
        if (this.delegate != null) {
            this.delegate.log(level, message);
        }
    }

    @Override
    public void log(ILoggingLogLevel level, String category, String message) {
        if (this.delegate != null) {
            this.delegate.log(level, category, message);
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "logLevelMessage": {
                ILoggingLogLevel level0 = (ILoggingLogLevel)((Object)this.getJSONParser().fromJson(request.getParameters()[0], ILoggingLogLevel.class));
                String message0 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                this.log(level0, message0);
                break;
            }
            case "logLevelCategoryMessage": {
                ILoggingLogLevel level1 = (ILoggingLogLevel)((Object)this.getJSONParser().fromJson(request.getParameters()[0], ILoggingLogLevel.class));
                String category1 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                String message1 = (String)this.getJSONParser().fromJson(request.getParameters()[2], String.class);
                this.log(level1, category1, message1);
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "LoggingBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.7.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

