/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseSystemBridge;
import me.adaptive.arp.api.DisplayOrientationListenerImpl;
import me.adaptive.arp.api.ICapabilitiesOrientation;
import me.adaptive.arp.api.IDisplay;
import me.adaptive.arp.api.IDisplayOrientationListener;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.LoggingBridge;

public class DisplayBridge
extends BaseSystemBridge
implements IDisplay,
APIBridge {
    private IDisplay delegate;

    public DisplayBridge(IDisplay delegate) {
        this.delegate = delegate;
    }

    public final IDisplay getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IDisplay delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addDisplayOrientationListener(IDisplayOrientationListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing addDisplayOrientationListener...");
        }
        if (this.delegate != null) {
            this.delegate.addDisplayOrientationListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'addDisplayOrientationListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'addDisplayOrientationListener'.");
        }
    }

    @Override
    public ICapabilitiesOrientation getOrientationCurrent() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getOrientationCurrent...");
        }
        ICapabilitiesOrientation result = null;
        if (this.delegate != null) {
            result = this.delegate.getOrientationCurrent();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getOrientationCurrent' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getOrientationCurrent'.");
        }
        return result;
    }

    @Override
    public void removeDisplayOrientationListener(IDisplayOrientationListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeDisplayOrientationListener...");
        }
        if (this.delegate != null) {
            this.delegate.removeDisplayOrientationListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeDisplayOrientationListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeDisplayOrientationListener'.");
        }
    }

    @Override
    public void removeDisplayOrientationListeners() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeDisplayOrientationListeners...");
        }
        if (this.delegate != null) {
            this.delegate.removeDisplayOrientationListeners();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeDisplayOrientationListeners' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeDisplayOrientationListeners'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "addDisplayOrientationListener": {
                DisplayOrientationListenerImpl listener0 = new DisplayOrientationListenerImpl(request.getAsyncId());
                this.addDisplayOrientationListener(listener0);
                break;
            }
            case "getOrientationCurrent": {
                ICapabilitiesOrientation response1 = this.getOrientationCurrent();
                if (response1 == null) break;
                responseJSON = AppRegistryBridge.escapeString(this.getJSONParser().toJson((Object)response1));
                break;
            }
            case "removeDisplayOrientationListener": {
                DisplayOrientationListenerImpl listener2 = new DisplayOrientationListenerImpl(request.getAsyncId());
                this.removeDisplayOrientationListener(listener2);
                break;
            }
            case "removeDisplayOrientationListeners": {
                this.removeDisplayOrientationListeners();
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "DisplayBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.7.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

