/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BasePIMBridge;
import me.adaptive.arp.api.ContactPhotoResultCallbackImpl;
import me.adaptive.arp.api.ContactResultCallbackImpl;
import me.adaptive.arp.api.ContactUid;
import me.adaptive.arp.api.IContact;
import me.adaptive.arp.api.IContactFieldGroup;
import me.adaptive.arp.api.IContactFilter;
import me.adaptive.arp.api.IContactPhotoResultCallback;
import me.adaptive.arp.api.IContactResultCallback;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.LoggingBridge;

public class ContactBridge
extends BasePIMBridge
implements IContact,
APIBridge {
    private IContact delegate;

    public ContactBridge(IContact delegate) {
        this.delegate = delegate;
    }

    public final IContact getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IContact delegate) {
        this.delegate = delegate;
    }

    @Override
    public void getContact(ContactUid contact, IContactResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getContact...");
        }
        if (this.delegate != null) {
            this.delegate.getContact(contact, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getContact' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getContact'.");
        }
    }

    @Override
    public void getContactPhoto(ContactUid contact, IContactPhotoResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getContactPhoto...");
        }
        if (this.delegate != null) {
            this.delegate.getContactPhoto(contact, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getContactPhoto' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getContactPhoto'.");
        }
    }

    @Override
    public void getContacts(IContactResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getContacts...");
        }
        if (this.delegate != null) {
            this.delegate.getContacts(callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getContacts' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getContacts'.");
        }
    }

    @Override
    public void getContactsForFields(IContactResultCallback callback, IContactFieldGroup[] fields) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getContactsForFields...");
        }
        if (this.delegate != null) {
            this.delegate.getContactsForFields(callback, fields);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getContactsForFields' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getContactsForFields'.");
        }
    }

    @Override
    public void getContactsWithFilter(IContactResultCallback callback, IContactFieldGroup[] fields, IContactFilter[] filter) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getContactsWithFilter...");
        }
        if (this.delegate != null) {
            this.delegate.getContactsWithFilter(callback, fields, filter);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getContactsWithFilter' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getContactsWithFilter'.");
        }
    }

    @Override
    public void searchContacts(String term, IContactResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing searchContacts...");
        }
        if (this.delegate != null) {
            this.delegate.searchContacts(term, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'searchContacts' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'searchContacts'.");
        }
    }

    @Override
    public void searchContactsWithFilter(String term, IContactResultCallback callback, IContactFilter[] filter) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing searchContactsWithFilter...");
        }
        if (this.delegate != null) {
            this.delegate.searchContactsWithFilter(term, callback, filter);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'searchContactsWithFilter' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'searchContactsWithFilter'.");
        }
    }

    @Override
    public boolean setContactPhoto(ContactUid contact, byte[] pngImage) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing setContactPhoto...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.setContactPhoto(contact, pngImage);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'setContactPhoto' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'setContactPhoto'.");
        }
        return result;
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "getContact": {
                ContactUid contact0 = (ContactUid)this.getJSONParser().fromJson(request.getParameters()[0], ContactUid.class);
                ContactResultCallbackImpl callback0 = new ContactResultCallbackImpl(request.getAsyncId());
                this.getContact(contact0, callback0);
                break;
            }
            case "getContactPhoto": {
                ContactUid contact1 = (ContactUid)this.getJSONParser().fromJson(request.getParameters()[0], ContactUid.class);
                ContactPhotoResultCallbackImpl callback1 = new ContactPhotoResultCallbackImpl(request.getAsyncId());
                this.getContactPhoto(contact1, callback1);
                break;
            }
            case "getContacts": {
                ContactResultCallbackImpl callback2 = new ContactResultCallbackImpl(request.getAsyncId());
                this.getContacts(callback2);
                break;
            }
            case "getContactsForFields": {
                ContactResultCallbackImpl callback3 = new ContactResultCallbackImpl(request.getAsyncId());
                IContactFieldGroup[] fields3 = (IContactFieldGroup[])this.getJSONParser().fromJson(request.getParameters()[1], IContactFieldGroup[].class);
                this.getContactsForFields(callback3, fields3);
                break;
            }
            case "getContactsWithFilter": {
                ContactResultCallbackImpl callback4 = new ContactResultCallbackImpl(request.getAsyncId());
                IContactFieldGroup[] fields4 = (IContactFieldGroup[])this.getJSONParser().fromJson(request.getParameters()[1], IContactFieldGroup[].class);
                IContactFilter[] filter4 = (IContactFilter[])this.getJSONParser().fromJson(request.getParameters()[2], IContactFilter[].class);
                this.getContactsWithFilter(callback4, fields4, filter4);
                break;
            }
            case "searchContacts": {
                String term5 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                ContactResultCallbackImpl callback5 = new ContactResultCallbackImpl(request.getAsyncId());
                this.searchContacts(term5, callback5);
                break;
            }
            case "searchContactsWithFilter": {
                String term6 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                ContactResultCallbackImpl callback6 = new ContactResultCallbackImpl(request.getAsyncId());
                IContactFilter[] filter6 = (IContactFilter[])this.getJSONParser().fromJson(request.getParameters()[2], IContactFilter[].class);
                this.searchContactsWithFilter(term6, callback6, filter6);
                break;
            }
            case "setContactPhoto": {
                ContactUid contact7 = (ContactUid)this.getJSONParser().fromJson(request.getParameters()[0], ContactUid.class);
                byte[] pngImage7 = (byte[])this.getJSONParser().fromJson(request.getParameters()[1], byte[].class);
                boolean response7 = this.setContactPhoto(contact7, pngImage7);
                responseJSON = AppRegistryBridge.escapeString(this.getJSONParser().toJson((Object)response7));
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "ContactBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.7.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

