/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseMediaBridge;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.IVideo;
import me.adaptive.arp.api.LoggingBridge;

public class VideoBridge
extends BaseMediaBridge
implements IVideo,
APIBridge {
    private IVideo delegate;

    public VideoBridge(IVideo delegate) {
        this.delegate = delegate;
    }

    public final IVideo getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IVideo delegate) {
        this.delegate = delegate;
    }

    @Override
    public void playStream(String url) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing playStream...");
        }
        if (this.delegate != null) {
            this.delegate.playStream(url);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'playStream' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'playStream'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "playStream": {
                String url0 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                this.playStream(url0);
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "VideoBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.4.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

