/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseApplicationBridge;
import me.adaptive.arp.api.IGlobalization;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.KeyPair;
import me.adaptive.arp.api.Locale;
import me.adaptive.arp.api.LoggingBridge;

public class GlobalizationBridge
extends BaseApplicationBridge
implements IGlobalization,
APIBridge {
    private IGlobalization delegate;

    public GlobalizationBridge(IGlobalization delegate) {
        this.delegate = delegate;
    }

    public final IGlobalization getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IGlobalization delegate) {
        this.delegate = delegate;
    }

    @Override
    public Locale getDefaultLocale() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getDefaultLocale...");
        }
        Locale result = null;
        if (this.delegate != null) {
            result = this.delegate.getDefaultLocale();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getDefaultLocale' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getDefaultLocale'.");
        }
        return result;
    }

    @Override
    public Locale[] getLocaleSupportedDescriptors() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getLocaleSupportedDescriptors...");
        }
        Locale[] result = null;
        if (this.delegate != null) {
            result = this.delegate.getLocaleSupportedDescriptors();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getLocaleSupportedDescriptors' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getLocaleSupportedDescriptors'.");
        }
        return result;
    }

    @Override
    public String getResourceLiteral(String key, Locale locale) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getResourceLiteral...");
        }
        String result = null;
        if (this.delegate != null) {
            result = this.delegate.getResourceLiteral(key, locale);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getResourceLiteral' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getResourceLiteral'.");
        }
        return result;
    }

    @Override
    public KeyPair[] getResourceLiterals(Locale locale) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getResourceLiterals...");
        }
        KeyPair[] result = null;
        if (this.delegate != null) {
            result = this.delegate.getResourceLiterals(locale);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getResourceLiterals' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getResourceLiterals'.");
        }
        return result;
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "getDefaultLocale": {
                Locale response0 = this.getDefaultLocale();
                if (response0 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response0);
                break;
            }
            case "getLocaleSupportedDescriptors": {
                Locale[] response1 = this.getLocaleSupportedDescriptors();
                if (response1 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response1);
                break;
            }
            case "getResourceLiteral": {
                String key2 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                Locale locale2 = (Locale)this.getJSONParser().fromJson(request.getParameters()[1], Locale.class);
                String response2 = this.getResourceLiteral(key2, locale2);
                if (response2 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response2);
                break;
            }
            case "getResourceLiterals": {
                Locale locale3 = (Locale)this.getJSONParser().fromJson(request.getParameters()[0], Locale.class);
                KeyPair[] response3 = this.getResourceLiterals(locale3);
                if (response3 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response3);
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "GlobalizationBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.3.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

