/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseSystemBridge;
import me.adaptive.arp.api.ButtonListenerImpl;
import me.adaptive.arp.api.DeviceInfo;
import me.adaptive.arp.api.DeviceOrientationListenerImpl;
import me.adaptive.arp.api.IButtonListener;
import me.adaptive.arp.api.ICapabilitiesOrientation;
import me.adaptive.arp.api.IDevice;
import me.adaptive.arp.api.IDeviceOrientationListener;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.Locale;
import me.adaptive.arp.api.LoggingBridge;

public class DeviceBridge
extends BaseSystemBridge
implements IDevice,
APIBridge {
    private IDevice delegate;

    public DeviceBridge(IDevice delegate) {
        this.delegate = delegate;
    }

    public final IDevice getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IDevice delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addButtonListener(IButtonListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing addButtonListener...");
        }
        if (this.delegate != null) {
            this.delegate.addButtonListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'addButtonListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'addButtonListener'.");
        }
    }

    @Override
    public void addDeviceOrientationListener(IDeviceOrientationListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing addDeviceOrientationListener...");
        }
        if (this.delegate != null) {
            this.delegate.addDeviceOrientationListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'addDeviceOrientationListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'addDeviceOrientationListener'.");
        }
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getDeviceInfo...");
        }
        DeviceInfo result = null;
        if (this.delegate != null) {
            result = this.delegate.getDeviceInfo();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getDeviceInfo' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getDeviceInfo'.");
        }
        return result;
    }

    @Override
    public Locale getLocaleCurrent() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getLocaleCurrent...");
        }
        Locale result = null;
        if (this.delegate != null) {
            result = this.delegate.getLocaleCurrent();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getLocaleCurrent' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getLocaleCurrent'.");
        }
        return result;
    }

    @Override
    public ICapabilitiesOrientation getOrientationCurrent() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getOrientationCurrent...");
        }
        ICapabilitiesOrientation result = null;
        if (this.delegate != null) {
            result = this.delegate.getOrientationCurrent();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getOrientationCurrent' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getOrientationCurrent'.");
        }
        return result;
    }

    @Override
    public void removeButtonListener(IButtonListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeButtonListener...");
        }
        if (this.delegate != null) {
            this.delegate.removeButtonListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeButtonListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeButtonListener'.");
        }
    }

    @Override
    public void removeButtonListeners() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeButtonListeners...");
        }
        if (this.delegate != null) {
            this.delegate.removeButtonListeners();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeButtonListeners' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeButtonListeners'.");
        }
    }

    @Override
    public void removeDeviceOrientationListener(IDeviceOrientationListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeDeviceOrientationListener...");
        }
        if (this.delegate != null) {
            this.delegate.removeDeviceOrientationListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeDeviceOrientationListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeDeviceOrientationListener'.");
        }
    }

    @Override
    public void removeDeviceOrientationListeners() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeDeviceOrientationListeners...");
        }
        if (this.delegate != null) {
            this.delegate.removeDeviceOrientationListeners();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeDeviceOrientationListeners' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeDeviceOrientationListeners'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "addButtonListener": {
                ButtonListenerImpl listener0 = new ButtonListenerImpl(request.getAsyncId());
                this.addButtonListener(listener0);
                break;
            }
            case "addDeviceOrientationListener": {
                DeviceOrientationListenerImpl listener1 = new DeviceOrientationListenerImpl(request.getAsyncId());
                this.addDeviceOrientationListener(listener1);
                break;
            }
            case "getDeviceInfo": {
                DeviceInfo response2 = this.getDeviceInfo();
                if (response2 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response2);
                break;
            }
            case "getLocaleCurrent": {
                Locale response3 = this.getLocaleCurrent();
                if (response3 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response3);
                break;
            }
            case "getOrientationCurrent": {
                ICapabilitiesOrientation response4 = this.getOrientationCurrent();
                if (response4 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response4);
                break;
            }
            case "removeButtonListener": {
                ButtonListenerImpl listener5 = new ButtonListenerImpl(request.getAsyncId());
                this.removeButtonListener(listener5);
                break;
            }
            case "removeButtonListeners": {
                this.removeButtonListeners();
                break;
            }
            case "removeDeviceOrientationListener": {
                DeviceOrientationListenerImpl listener7 = new DeviceOrientationListenerImpl(request.getAsyncId());
                this.removeDeviceOrientationListener(listener7);
                break;
            }
            case "removeDeviceOrientationListeners": {
                this.removeDeviceOrientationListeners();
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "DeviceBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.3.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

