/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseDataBridge;
import me.adaptive.arp.api.FileDataLoadResultCallbackImpl;
import me.adaptive.arp.api.FileDataStoreResultCallbackImpl;
import me.adaptive.arp.api.FileDescriptor;
import me.adaptive.arp.api.FileListResultCallbackImpl;
import me.adaptive.arp.api.FileResultCallbackImpl;
import me.adaptive.arp.api.IFile;
import me.adaptive.arp.api.IFileDataLoadResultCallback;
import me.adaptive.arp.api.IFileDataStoreResultCallback;
import me.adaptive.arp.api.IFileListResultCallback;
import me.adaptive.arp.api.IFileResultCallback;
import me.adaptive.arp.api.IFileSystemSecurity;
import me.adaptive.arp.api.IFileSystemStorageType;
import me.adaptive.arp.api.IFileSystemType;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.LoggingBridge;

public class FileBridge
extends BaseDataBridge
implements IFile,
APIBridge {
    private IFile delegate;

    public FileBridge(IFile delegate) {
        this.delegate = delegate;
    }

    public final IFile getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IFile delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean canRead(FileDescriptor descriptor) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing canRead...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.canRead(descriptor);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'canRead' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'canRead'.");
        }
        return result;
    }

    @Override
    public boolean canWrite(FileDescriptor descriptor) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing canWrite...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.canWrite(descriptor);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'canWrite' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'canWrite'.");
        }
        return result;
    }

    @Override
    public void create(FileDescriptor descriptor, IFileResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing create...");
        }
        if (this.delegate != null) {
            this.delegate.create(descriptor, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'create' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'create'.");
        }
    }

    @Override
    public boolean delete(FileDescriptor descriptor, boolean cascade) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing delete...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.delete(descriptor, cascade);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'delete' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'delete'.");
        }
        return result;
    }

    @Override
    public boolean exists(FileDescriptor descriptor) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing exists...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.exists(descriptor);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'exists' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'exists'.");
        }
        return result;
    }

    @Override
    public void getContent(FileDescriptor descriptor, IFileDataLoadResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getContent...");
        }
        if (this.delegate != null) {
            this.delegate.getContent(descriptor, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getContent' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getContent'.");
        }
    }

    @Override
    public IFileSystemStorageType getFileStorageType(FileDescriptor descriptor) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getFileStorageType...");
        }
        IFileSystemStorageType result = null;
        if (this.delegate != null) {
            result = this.delegate.getFileStorageType(descriptor);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getFileStorageType' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getFileStorageType'.");
        }
        return result;
    }

    @Override
    public IFileSystemType getFileType(FileDescriptor descriptor) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getFileType...");
        }
        IFileSystemType result = null;
        if (this.delegate != null) {
            result = this.delegate.getFileType(descriptor);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getFileType' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getFileType'.");
        }
        return result;
    }

    @Override
    public IFileSystemSecurity getSecurityType(FileDescriptor descriptor) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getSecurityType...");
        }
        IFileSystemSecurity result = null;
        if (this.delegate != null) {
            result = this.delegate.getSecurityType(descriptor);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getSecurityType' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getSecurityType'.");
        }
        return result;
    }

    @Override
    public boolean isDirectory(FileDescriptor descriptor) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing isDirectory...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.isDirectory(descriptor);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'isDirectory' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'isDirectory'.");
        }
        return result;
    }

    @Override
    public void listFiles(FileDescriptor descriptor, IFileListResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing listFiles...");
        }
        if (this.delegate != null) {
            this.delegate.listFiles(descriptor, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'listFiles' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'listFiles'.");
        }
    }

    @Override
    public void listFilesForRegex(FileDescriptor descriptor, String regex, IFileListResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing listFilesForRegex...");
        }
        if (this.delegate != null) {
            this.delegate.listFilesForRegex(descriptor, regex, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'listFilesForRegex' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'listFilesForRegex'.");
        }
    }

    @Override
    public boolean mkDir(FileDescriptor descriptor, boolean recursive) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing mkDir...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.mkDir(descriptor, recursive);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'mkDir' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'mkDir'.");
        }
        return result;
    }

    @Override
    public void move(FileDescriptor source, FileDescriptor destination, boolean createPath, boolean overwrite, IFileResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing move...");
        }
        if (this.delegate != null) {
            this.delegate.move(source, destination, createPath, overwrite, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'move' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'move'.");
        }
    }

    @Override
    public void setContent(FileDescriptor descriptor, byte[] content, IFileDataStoreResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing setContent...");
        }
        if (this.delegate != null) {
            this.delegate.setContent(descriptor, content, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'setContent' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'setContent'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "canRead": {
                FileDescriptor descriptor0 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                boolean response0 = this.canRead(descriptor0);
                responseJSON = "" + response0;
                break;
            }
            case "canWrite": {
                FileDescriptor descriptor1 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                boolean response1 = this.canWrite(descriptor1);
                responseJSON = "" + response1;
                break;
            }
            case "create": {
                FileDescriptor descriptor2 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                FileResultCallbackImpl callback2 = new FileResultCallbackImpl(request.getAsyncId());
                this.create(descriptor2, callback2);
                break;
            }
            case "delete": {
                FileDescriptor descriptor3 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                boolean cascade3 = (Boolean)this.getJSONParser().fromJson(request.getParameters()[1], Boolean.TYPE);
                boolean response3 = this.delete(descriptor3, cascade3);
                responseJSON = "" + response3;
                break;
            }
            case "exists": {
                FileDescriptor descriptor4 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                boolean response4 = this.exists(descriptor4);
                responseJSON = "" + response4;
                break;
            }
            case "getContent": {
                FileDescriptor descriptor5 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                FileDataLoadResultCallbackImpl callback5 = new FileDataLoadResultCallbackImpl(request.getAsyncId());
                this.getContent(descriptor5, callback5);
                break;
            }
            case "getFileStorageType": {
                FileDescriptor descriptor6 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                IFileSystemStorageType response6 = this.getFileStorageType(descriptor6);
                if (response6 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response6);
                break;
            }
            case "getFileType": {
                FileDescriptor descriptor7 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                IFileSystemType response7 = this.getFileType(descriptor7);
                if (response7 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response7);
                break;
            }
            case "getSecurityType": {
                FileDescriptor descriptor8 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                IFileSystemSecurity response8 = this.getSecurityType(descriptor8);
                if (response8 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response8);
                break;
            }
            case "isDirectory": {
                FileDescriptor descriptor9 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                boolean response9 = this.isDirectory(descriptor9);
                responseJSON = "" + response9;
                break;
            }
            case "listFiles": {
                FileDescriptor descriptor10 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                FileListResultCallbackImpl callback10 = new FileListResultCallbackImpl(request.getAsyncId());
                this.listFiles(descriptor10, callback10);
                break;
            }
            case "listFilesForRegex": {
                FileDescriptor descriptor11 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                String regex11 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                FileListResultCallbackImpl callback11 = new FileListResultCallbackImpl(request.getAsyncId());
                this.listFilesForRegex(descriptor11, regex11, callback11);
                break;
            }
            case "mkDir": {
                FileDescriptor descriptor12 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                boolean recursive12 = (Boolean)this.getJSONParser().fromJson(request.getParameters()[1], Boolean.TYPE);
                boolean response12 = this.mkDir(descriptor12, recursive12);
                responseJSON = "" + response12;
                break;
            }
            case "move": {
                FileDescriptor source13 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                FileDescriptor destination13 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[1], FileDescriptor.class);
                boolean createPath13 = (Boolean)this.getJSONParser().fromJson(request.getParameters()[2], Boolean.TYPE);
                boolean overwrite13 = (Boolean)this.getJSONParser().fromJson(request.getParameters()[3], Boolean.TYPE);
                FileResultCallbackImpl callback13 = new FileResultCallbackImpl(request.getAsyncId());
                this.move(source13, destination13, createPath13, overwrite13, callback13);
                break;
            }
            case "setContent": {
                FileDescriptor descriptor14 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                byte[] content14 = (byte[])this.getJSONParser().fromJson(request.getParameters()[1], byte[].class);
                FileDataStoreResultCallbackImpl callback14 = new FileDataStoreResultCallbackImpl(request.getAsyncId());
                this.setContent(descriptor14, content14, callback14);
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "FileBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.12.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

