/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseUIBridge;
import me.adaptive.arp.api.IBrowser;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.LoggingBridge;

public class BrowserBridge
extends BaseUIBridge
implements IBrowser,
APIBridge {
    private IBrowser delegate;

    public BrowserBridge(IBrowser delegate) {
        this.delegate = delegate;
    }

    public final IBrowser getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IBrowser delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean openExtenalBrowser(String url) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing openExtenalBrowser...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.openExtenalBrowser(url);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'openExtenalBrowser' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'openExtenalBrowser'.");
        }
        return result;
    }

    @Override
    public boolean openInternalBrowser(String url, String title, String backButtonText) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing openInternalBrowser...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.openInternalBrowser(url, title, backButtonText);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'openInternalBrowser' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'openInternalBrowser'.");
        }
        return result;
    }

    @Override
    public boolean openInternalBrowserModal(String url, String title, String backButtonText) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing openInternalBrowserModal...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.openInternalBrowserModal(url, title, backButtonText);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'openInternalBrowserModal' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'openInternalBrowserModal'.");
        }
        return result;
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "openExtenalBrowser": {
                String url0 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                boolean response0 = this.openExtenalBrowser(url0);
                responseJSON = "" + response0;
                break;
            }
            case "openInternalBrowser": {
                String url1 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                String title1 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                String backButtonText1 = (String)this.getJSONParser().fromJson(request.getParameters()[2], String.class);
                boolean response1 = this.openInternalBrowser(url1, title1, backButtonText1);
                responseJSON = "" + response1;
                break;
            }
            case "openInternalBrowserModal": {
                String url2 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                String title2 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                String backButtonText2 = (String)this.getJSONParser().fromJson(request.getParameters()[2], String.class);
                boolean response2 = this.openInternalBrowserModal(url2, title2, backButtonText2);
                responseJSON = "" + response2;
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "BrowserBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.12.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

