/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AccelerationListenerImpl;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseSensorBridge;
import me.adaptive.arp.api.IAcceleration;
import me.adaptive.arp.api.IAccelerationListener;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.LoggingBridge;

public class AccelerationBridge
extends BaseSensorBridge
implements IAcceleration,
APIBridge {
    private IAcceleration delegate;

    public AccelerationBridge(IAcceleration delegate) {
        this.delegate = delegate;
    }

    public final IAcceleration getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IAcceleration delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addAccelerationListener(IAccelerationListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing addAccelerationListener...");
        }
        if (this.delegate != null) {
            this.delegate.addAccelerationListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'addAccelerationListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'addAccelerationListener'.");
        }
    }

    @Override
    public void removeAccelerationListener(IAccelerationListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeAccelerationListener...");
        }
        if (this.delegate != null) {
            this.delegate.removeAccelerationListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeAccelerationListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeAccelerationListener'.");
        }
    }

    @Override
    public void removeAccelerationListeners() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeAccelerationListeners...");
        }
        if (this.delegate != null) {
            this.delegate.removeAccelerationListeners();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeAccelerationListeners' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeAccelerationListeners'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "addAccelerationListener": {
                AccelerationListenerImpl listener0 = new AccelerationListenerImpl(request.getAsyncId());
                this.addAccelerationListener(listener0);
                break;
            }
            case "removeAccelerationListener": {
                AccelerationListenerImpl listener1 = new AccelerationListenerImpl(request.getAsyncId());
                this.removeAccelerationListener(listener1);
                break;
            }
            case "removeAccelerationListeners": {
                this.removeAccelerationListeners();
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "AccelerationBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.12.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

